/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ExclusionSearch;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.internal.datatypes.impl.DimensionImpl;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.services.IGefService;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;

public class GefService
implements IGefService {
    protected static final String PE = "*PE* ";

    @Override
    public void selectEditPart(EditPartViewer viewer, Object modelObject) {
        if (modelObject == null) {
            return;
        }
        viewer.getControl().forceFocus();
        Object editpart = viewer.getEditPartRegistry().get(modelObject);
        if (editpart instanceof EditPart) {
            viewer.flush();
            viewer.select((EditPart)editpart);
        }
    }

    @Override
    public Point calculateTranslation(EditPart source, EditPart target) {
        if (!(source instanceof GraphicalEditPart) || !(target instanceof GraphicalEditPart)) {
            throw new RuntimeException("Both EditParts must be an instance of GraphicalEditPart: " + source + " " + target);
        }
        Point result = new Point(0, 0);
        if (source == target) {
            return result;
        }
        ((GraphicalEditPart)source).getContentPane().translateToAbsolute((Translatable)result);
        ((GraphicalEditPart)target).getContentPane().translateToRelative((Translatable)result);
        return result;
    }

    @Override
    public Object getLayoutConstraint(EditPart editPart) {
        IFigure childFigure;
        if (editPart instanceof GraphicalEditPart && (childFigure = ((GraphicalEditPart)editPart).getFigure()).getParent() != null && childFigure.getParent().getLayoutManager() != null) {
            Object constraint = childFigure.getParent().getLayoutManager().getConstraint(childFigure);
            return constraint;
        }
        return null;
    }

    @Override
    public EditPart findEditPartAt(EditPartViewer viewer, Point location, boolean includeConnections) {
        List<EditPart> children;
        EditPart editPart = this.findObjectAt(viewer, location, includeConnections);
        if (editPart instanceof ScalableRootEditPartAnimated && (children = this.getEditPartChildren(editPart)).size() > 0) {
            editPart = children.get(0);
        }
        return editPart;
    }

    private EditPart findObjectAt(final EditPartViewer viewer, Point pt, boolean includeConnections) {
        class ConditionalTreeSearch
        extends ExclusionSearch {
            ConditionalTreeSearch(Collection<?> coll) {
                super(coll);
            }

            public boolean accept(IFigure figure) {
                EditPart editpart = null;
                while (editpart == null && figure != null) {
                    editpart = (EditPart)viewer.getVisualPartMap().get(figure);
                    figure = figure.getParent();
                }
                return editpart != null;
            }
        }
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        IFigure figure = null;
        if (includeConnections) {
            IFigure connectionLayer = rootEditPart.getLayer((Object)"Connection Layer");
            figure = connectionLayer.findFigureAt(pt.x, pt.y, (TreeSearch)new ConditionalTreeSearch((Collection)Collections.EMPTY_LIST));
        }
        if (figure == null) {
            IFigure primaryLayer = rootEditPart.getLayer((Object)"Primary Layer");
            figure = primaryLayer.findFigureAt(pt.x, pt.y, (TreeSearch)new ConditionalTreeSearch((Collection)Collections.EMPTY_LIST));
        }
        EditPart part = null;
        while (part == null && figure != null) {
            part = (EditPart)viewer.getVisualPartMap().get(figure);
            figure = figure.getParent();
        }
        if (part == null) {
            return viewer.getContents();
        }
        return part;
    }

    @Override
    public List<EditPart> getConnectionsContainedInEditPart(EditPart ep) {
        List<EditPart> childEditParts = this.getAllEditPartChildren(ep);
        ArrayList<Connection> sourceConnections = new ArrayList<Connection>();
        ArrayList<Connection> targetConnections = new ArrayList<Connection>();
        for (EditPart cep : childEditParts) {
            if (!(cep instanceof ShapeEditPart)) continue;
            ShapeEditPart sep = (ShapeEditPart)cep;
            sourceConnections.addAll(sep.getModelSourceConnections());
            targetConnections.addAll(sep.getModelTargetConnections());
        }
        sourceConnections.retainAll(targetConnections);
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        for (Connection connection : sourceConnections) {
            Object connectionEditPart = ep.getRoot().getViewer().getEditPartRegistry().get(connection);
            result.add((EditPart)connectionEditPart);
            EList connectionDecorators = connection.getConnectionDecorators();
            for (ConnectionDecorator decorator : connectionDecorators) {
                Object decoratorEditPart = ep.getRoot().getViewer().getEditPartRegistry().get(decorator);
                result.add((EditPart)decoratorEditPart);
            }
        }
        return result;
    }

    private List<EditPart> getAllEditPartChildren(EditPart ep) {
        ArrayList<EditPart> res = new ArrayList<EditPart>();
        List<EditPart> children = this.getEditPartChildren(ep);
        for (EditPart editPart : children) {
            res.add(editPart);
            res.addAll(this.getAllEditPartChildren(editPart));
        }
        return res;
    }

    @Override
    public Point getConnectionPointAt(Connection c, double d) {
        Point ret = null;
        Anchor startAnchor = c.getStart();
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation startLocation = layoutService.getLocationRelativeToDiagram(startAnchor);
        Point startPoint = new Point(startLocation.getX(), startLocation.getY());
        Anchor endAnchor = c.getEnd();
        ILocation endLocation = layoutService.getLocationRelativeToDiagram(endAnchor);
        Point endPoint = new Point(endLocation.getX(), endLocation.getY());
        if (startAnchor instanceof ChopboxAnchor || endAnchor instanceof ChopboxAnchor) {
            Point chopboxLocationOnBox;
            FreeFormConnection ffc;
            EList bendpoints;
            Rectangle parentRect;
            ILocation location;
            Shape shape;
            GraphicsAlgorithm parentGa;
            if (startAnchor instanceof ChopboxAnchor) {
                ChopboxAnchor cbStartAnchor = (ChopboxAnchor)startAnchor;
                parentGa = cbStartAnchor.getParent().getGraphicsAlgorithm();
                shape = (Shape)cbStartAnchor.getParent();
                location = layoutService.getLocationRelativeToDiagram(shape);
                parentRect = new Rectangle(location.getX(), location.getY(), parentGa.getWidth(), parentGa.getHeight());
                Point pointNextToStartAnchor = endPoint.getCopy();
                if (c instanceof FreeFormConnection && !(bendpoints = (ffc = (FreeFormConnection)c).getBendpoints()).isEmpty()) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point firstBendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendpoints.get(0);
                    pointNextToStartAnchor.setLocation(firstBendpoint.getX(), firstBendpoint.getY());
                }
                chopboxLocationOnBox = this.getChopboxLocationOnBox(pointNextToStartAnchor, parentRect);
                startPoint.setLocation(chopboxLocationOnBox);
            }
            if (endAnchor instanceof ChopboxAnchor) {
                ChopboxAnchor cbEndAnchor = (ChopboxAnchor)endAnchor;
                parentGa = cbEndAnchor.getParent().getGraphicsAlgorithm();
                shape = (Shape)cbEndAnchor.getParent();
                location = layoutService.getLocationRelativeToDiagram(shape);
                parentRect = new Rectangle(location.getX(), location.getY(), parentGa.getWidth(), parentGa.getHeight());
                Point pointNextToEndAnchor = startPoint.getCopy();
                if (c instanceof FreeFormConnection && !(bendpoints = (ffc = (FreeFormConnection)c).getBendpoints()).isEmpty()) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point lastBendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendpoints.get(bendpoints.size() - 1);
                    pointNextToEndAnchor.setLocation(lastBendpoint.getX(), lastBendpoint.getY());
                }
                chopboxLocationOnBox = this.getChopboxLocationOnBox(pointNextToEndAnchor, parentRect);
                endPoint.setLocation(chopboxLocationOnBox);
            }
        }
        if (c instanceof FreeFormConnection) {
            FreeFormConnection ffc = (FreeFormConnection)c;
            EList bendpoints = ffc.getBendpoints();
            Point[] draw2dPoints = new Point[bendpoints.size() + 2];
            draw2dPoints[0] = startPoint;
            int i = 1;
            for (org.eclipse.graphiti.mm.algorithms.styles.Point pictogramsPoint : bendpoints) {
                draw2dPoints[i] = new Point(pictogramsPoint.getX(), pictogramsPoint.getY());
                ++i;
            }
            draw2dPoints[i] = endPoint;
            double completeDistance = this.getDistance(draw2dPoints);
            double absDistanceToRelPoint = completeDistance * d;
            double distanceSum = 0.0;
            int i2 = 0;
            while (i2 < draw2dPoints.length - 1) {
                double additionalDistanceToNext;
                double oldDistanceSum = distanceSum;
                Point currentPoint = draw2dPoints[i2];
                Point nextPoint = draw2dPoints[i2 + 1];
                if (!currentPoint.equals((Object)nextPoint) && (distanceSum += (additionalDistanceToNext = this.getDistance(currentPoint, nextPoint))) >= absDistanceToRelPoint) {
                    double thisRelative = (completeDistance * d - oldDistanceSum) / additionalDistanceToNext;
                    ret = this.getPointAt(currentPoint, nextPoint, thisRelative);
                    break;
                }
                ++i2;
            }
        } else {
            ret = this.getPointAt(startPoint.x, startPoint.y, endPoint.x, endPoint.y, d);
        }
        return ret;
    }

    @Override
    public Point getChopboxLocationOnBox(Point reference, Rectangle box) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(box);
        r.translate(-1, -1);
        r.resize(1, 1);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float max = Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        if (max <= 0.001f) {
            return new Point((int)centerX, r.y);
        }
        float scale = 0.5f / max;
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    @Override
    public Point getAbsolutePointOnConnection(Connection c, double distance) {
        Point ret = null;
        Anchor startAnchor = c.getStart();
        ILocation startLocation = Graphiti.getLayoutService().getLocationRelativeToDiagram(startAnchor);
        Point startPoint = new Point(startLocation.getX(), startLocation.getY());
        Anchor endAnchor = c.getEnd();
        ILocation endLocation = Graphiti.getLayoutService().getLocationRelativeToDiagram(endAnchor);
        Point endPoint = new Point(endLocation.getX(), endLocation.getY());
        if (startAnchor instanceof ChopboxAnchor || endAnchor instanceof ChopboxAnchor) {
            Point chopboxLocationOnBox;
            FreeFormConnection ffc;
            EList bendpoints;
            Rectangle parentRect;
            GraphicsAlgorithm parentGa;
            if (startAnchor instanceof ChopboxAnchor) {
                ChopboxAnchor cbStartAnchor = (ChopboxAnchor)startAnchor;
                parentGa = cbStartAnchor.getParent().getGraphicsAlgorithm();
                parentRect = new Rectangle(parentGa.getX(), parentGa.getY(), parentGa.getWidth(), parentGa.getHeight());
                Point pointNextToStartAnchor = endPoint.getCopy();
                if (c instanceof FreeFormConnection && !(bendpoints = (ffc = (FreeFormConnection)c).getBendpoints()).isEmpty()) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point firstBendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendpoints.get(0);
                    pointNextToStartAnchor.setLocation(firstBendpoint.getX(), firstBendpoint.getY());
                }
                chopboxLocationOnBox = this.getChopboxLocationOnBox(pointNextToStartAnchor, parentRect);
                startPoint.setLocation(chopboxLocationOnBox);
            }
            if (endAnchor instanceof ChopboxAnchor) {
                ChopboxAnchor cbEndAnchor = (ChopboxAnchor)endAnchor;
                parentGa = cbEndAnchor.getParent().getGraphicsAlgorithm();
                parentRect = new Rectangle(parentGa.getX(), parentGa.getY(), parentGa.getWidth(), parentGa.getHeight());
                Point pointNextToEndAnchor = startPoint.getCopy();
                if (c instanceof FreeFormConnection && !(bendpoints = (ffc = (FreeFormConnection)c).getBendpoints()).isEmpty()) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point lastBendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendpoints.get(bendpoints.size() - 1);
                    pointNextToEndAnchor.setLocation(lastBendpoint.getX(), lastBendpoint.getY());
                }
                chopboxLocationOnBox = this.getChopboxLocationOnBox(pointNextToEndAnchor, parentRect);
                endPoint.setLocation(chopboxLocationOnBox);
            }
        }
        if (c instanceof FreeFormConnection) {
            FreeFormConnection ffc = (FreeFormConnection)c;
            EList bendpoints = ffc.getBendpoints();
            Point[] draw2dPoints = new Point[bendpoints.size() + 2];
            draw2dPoints[0] = startPoint;
            int i = 1;
            for (org.eclipse.graphiti.mm.algorithms.styles.Point pictogramsPoint : bendpoints) {
                draw2dPoints[i] = new Point(pictogramsPoint.getX(), pictogramsPoint.getY());
                ++i;
            }
            draw2dPoints[i] = endPoint;
            if (distance < 0.0) {
                this.mirrorArray(draw2dPoints);
            }
            double absDistance = Math.abs(distance);
            double distanceSum = 0.0;
            int i2 = 0;
            while (i2 < draw2dPoints.length - 1) {
                Point currentPoint = draw2dPoints[i2];
                Point nextPoint = draw2dPoints[i2 + 1];
                double additionalDistanceToNext = this.getDistance(currentPoint, nextPoint);
                if ((distanceSum += additionalDistanceToNext) >= absDistance) {
                    ret = this.getDistantPoint(currentPoint, nextPoint, absDistance);
                    break;
                }
                ++i2;
            }
        } else {
            ret = this.getDistantPoint(startLocation.getX(), startLocation.getY(), endLocation.getX(), endLocation.getY(), distance);
        }
        if (ret == null) {
            ret = startPoint;
        }
        return ret;
    }

    @Override
    public Point getDistantPoint(Point start, Point end, double distance) {
        Point ret = this.getDistantPoint(start.x, start.y, end.x, end.y, distance);
        return ret;
    }

    @Override
    public Point getDistantPoint(int startX, int startY, int endX, int endY, double distance) {
        Point ret;
        double completeDistance = Math.sqrt((endX - startX) * (endX - startX) + (endY - startY) * (endY - startY));
        if (distance >= 0.0) {
            double relative = distance > completeDistance ? 1.0 : distance / completeDistance;
            ret = this.getPointAt(startX, startY, endX, endY, relative);
        } else {
            double relative = -distance > completeDistance ? 0.0 : 1.0 - distance / completeDistance;
            ret = this.getPointAt(startX, startY, endX, endY, relative);
        }
        return ret;
    }

    @Override
    public Point getPointAt(int startX, int startY, int endX, int endY, double d) {
        int midX = (int)Math.round((double)startX + d * (double)(endX - startX));
        int midY = (int)Math.round((double)startY + d * (double)(endY - startY));
        Point ret = new Point(midX, midY);
        return ret;
    }

    @Override
    public Point getPointAt(Point start, Point end, double d) {
        Point ret = this.getPointAt(start.x, start.y, end.x, end.y, d);
        return ret;
    }

    @Override
    public double getDistance(Point[] points) {
        double ret = 0.0;
        int i = 0;
        while (i < points.length - 1) {
            Point currentPoint = points[i];
            Point nextPoint = points[i + 1];
            ret += this.getDistance(currentPoint, nextPoint);
            ++i;
        }
        return ret;
    }

    private double getDistance(Point start, Point end) {
        int xDist = end.x - start.x;
        int yDist = end.y - start.y;
        double ret = Math.sqrt(xDist * xDist + yDist * yDist);
        return ret;
    }

    @Override
    public IDimension calculateTextSize(String text, Font font) {
        DimensionImpl dimension = null;
        if (text == null || font == null || font.getName() == null) {
            return dimension;
        }
        org.eclipse.swt.graphics.Font swtFont = DataTypeTransformation.toSwtFont(font);
        if (swtFont != null) {
            Dimension se = TextUtilities.INSTANCE.getStringExtents(text, swtFont);
            if (se != null) {
                dimension = new DimensionImpl(se.width, se.height);
            }
            if (!swtFont.isDisposed()) {
                swtFont.dispose();
            }
        }
        return dimension;
    }

    @Override
    public void mirrorArray(Point[] draw2dPoints) {
        int length = draw2dPoints.length;
        int i = 0;
        while (i < length / 2) {
            Point pTemp = draw2dPoints[length - 1 - i];
            draw2dPoints[length - 1 - i] = draw2dPoints[i];
            draw2dPoints[i] = pTemp;
            ++i;
        }
    }

    @Override
    public List<EditPart> getEditPartChildren(EditPart editPart) {
        List ret = editPart.getChildren();
        return ret;
    }

    @Override
    public List<GraphicalEditPart> getSourceConnections(GraphicalEditPart graphicalEditPart) {
        List sourceConnections = graphicalEditPart.getSourceConnections();
        return sourceConnections;
    }

    @Override
    public List<GraphicalEditPart> getTargetConnections(GraphicalEditPart graphicalEditPart) {
        List targetConnections = graphicalEditPart.getTargetConnections();
        return targetConnections;
    }

    @Override
    public List<EditPart> getSelectedEditParts(EditPartViewer editPartViewer) {
        List selectedEditParts = editPartViewer.getSelectedEditParts();
        return selectedEditParts;
    }
}

