/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.command.CommandContainer;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.jface.action.Action;

public class CustomAction
extends Action {
    private ICustomFeature customFeature;
    private ICustomContext context;
    private DiagramEditorInternal diagramEditor;

    public CustomAction(ICustomFeature customFeature, ICustomContext context, DiagramEditorInternal diagramEditor) {
        this.customFeature = customFeature;
        this.context = context;
        this.diagramEditor = diagramEditor;
        this.setText(customFeature.getName());
        this.setToolTipText(customFeature.getDescription());
    }

    public boolean isEnabled() {
        return this.customFeature.canExecute(this.context);
    }

    public void run() {
        CommandContainer commandContainer = new CommandContainer(this.customFeature.getFeatureProvider());
        commandContainer.add((ICommand)new GenericFeatureCommandWithContext((IFeature)this.customFeature, (IContext)this.context));
        this.executeOnCommandStack((ICommand)commandContainer);
    }

    protected void executeOnCommandStack(ICommand command) {
        CommandStack commandStack = this.diagramEditor.getEditDomain().getCommandStack();
        commandStack.execute((Command)new GefCommandWrapper(command, this.diagramEditor.getEditingDomain()));
    }
}

