/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.editor.DomainModelWorkspaceSynchronizerDelegate;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramEditorBehavior
extends PlatformObject
implements IEditingDomainProvider,
IOperationHistoryListener {
    private IEditorPart editorPart = null;
    private TransactionalEditingDomain editingDomain;
    private ElementDeleteListener elementDeleteListener = null;
    private final MarkerHelper markerHelper = new EditUIMarkerHelper();
    private final Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private boolean updateProblemIndication = true;
    private Runnable dirtyStateUpdater;
    private ResourceSetUpdateAdapter resourceSetUpdateAdapter;
    protected boolean resourceDeleted = false;
    private boolean resourceChanged = false;
    private WorkspaceSynchronizer workspaceSynchronizer;
    private final EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = DiagramEditorBehavior.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            DiagramEditorBehavior.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            DiagramEditorBehavior.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!DiagramEditorBehavior.this.updateProblemIndication) return;
                        DiagramEditorBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DiagramEditorBehavior.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    private final Adapter updateAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (!DiagramEditorBehavior.this.isAdapterActive()) {
                return;
            }
            if (msg.getFeatureID(Resource.class) == 4 && msg.getNewBooleanValue() == Boolean.FALSE.booleanValue()) {
                Resource resource = (Resource)msg.getNotifier();
                URI uri = resource.getURI();
                if (DiagramEditorBehavior.this.editingDomain.getResourceSet().getURIConverter().exists(uri, null)) {
                    DiagramEditorBehavior.this.setResourceChanged(true);
                    IEditorPart activeEditor = DiagramEditorBehavior.this.editorPart.getSite().getPage().getActiveEditor();
                    if (activeEditor == DiagramEditorBehavior.this.editorPart) {
                        DiagramEditorBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DiagramEditorBehavior.this.handleActivate();
                            }
                        });
                    }
                } else if (!DiagramEditorBehavior.this.isDirty()) {
                    IEditorInput editorInput = DiagramEditorBehavior.this.editorPart.getEditorInput();
                    if (editorInput instanceof DiagramEditorInput) {
                        Resource eResource;
                        DiagramEditorInput input = (DiagramEditorInput)editorInput;
                        EObject eObject = null;
                        try {
                            eObject = input.getEObject();
                        }
                        catch (Exception e) {
                            this.startCloseEditorJob();
                        }
                        if (eObject != null && ((eResource = eObject.eResource()) == null || eResource.equals(resource))) {
                            this.startCloseEditorJob();
                        }
                    }
                } else {
                    DiagramEditorBehavior.this.setResourceDeleted(true);
                    IEditorPart activeEditor = DiagramEditorBehavior.this.editorPart.getSite().getPage().getActiveEditor();
                    if (activeEditor == DiagramEditorBehavior.this.editorPart) {
                        DiagramEditorBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DiagramEditorBehavior.this.handleActivate();
                            }
                        });
                    }
                }
            }
            super.notifyChanged(msg);
        }

        private void startCloseEditorJob() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramEditorBehavior.this.closeEd();
                }
            });
        }
    };
    private boolean adapterActive;

    public boolean isResourceDeleted() {
        return this.resourceDeleted;
    }

    public void setResourceDeleted(boolean resourceDeleted) {
        this.resourceDeleted = resourceDeleted;
    }

    public boolean isResourceChanged() {
        return this.resourceChanged;
    }

    public void setResourceChanged(boolean resourceChanged) {
        this.resourceChanged = resourceChanged;
    }

    public DiagramEditorBehavior(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    private void initializeEditingDomain(TransactionalEditingDomain domain) {
        this.editingDomain = domain;
        ResourceSet resourceSet = domain.getResourceSet();
        this.resourceSetUpdateAdapter = new ResourceSetUpdateAdapter();
        resourceSet.eAdapters().add((Object)this.resourceSetUpdateAdapter);
        for (Resource r : resourceSet.getResources()) {
            r.eAdapters().add((Object)this.updateAdapter);
        }
        this.workspaceSynchronizer = new WorkspaceSynchronizer(this.getEditingDomain(), (WorkspaceSynchronizer.Delegate)new DomainModelWorkspaceSynchronizerDelegate(this));
    }

    private Shell getShell() {
        return this.editorPart.getSite().getShell();
    }

    private void closeEd() {
        IWorkbenchPartSite site = this.editorPart.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        page.closeEditor(this.editorPart, false);
    }

    private void handleActivate() {
        if (this.isResourceDeleted()) {
            if (this.handleDirtyConflict()) {
                this.closeEd();
            } else {
                this.setResourceDeleted(false);
                this.setResourceChanged(false);
            }
        } else if (this.isResourceChanged()) {
            this.handleChangedResources();
            this.setResourceChanged(false);
        }
    }

    protected boolean isAdapterActive() {
        return this.adapterActive;
    }

    private void setAdapterActive(boolean b) {
        this.adapterActive = b;
    }

    private void handleChangedResources() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            this.getOperationHistory().dispose(this.getUndoContext(), true, true, true);
            this.updateProblemIndication = false;
            this.setAdapterActive(false);
            try {
                EList resources = this.getEditingDomain().getResourceSet().getResources();
                for (Resource resource : resources) {
                    resource.unload();
                }
                this.refreshEditorContent();
            }
            finally {
                this.setAdapterActive(true);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    private void updateProblemIndication() {
        if (this.updateProblemIndication && this.editingDomain != null) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.graphiti.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
            }
            if (diagnostic.getSeverity() != 0) {
                try {
                    this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    T.racer().error(diagnostic.getMessage(), diagnostic.getException());
                }
                catch (CoreException exception) {
                    T.racer().error(exception.getMessage(), exception);
                }
            }
        }
    }

    private boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DiscardChangesDialog_0_xmsg, (String)Messages.DiscardChangesDialog_1_xmsg);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!(resource.getErrors().isEmpty() && resource.getWarnings().isEmpty() || this.editingDomain == null)) {
            IFile file = GraphitiUiInternal.getEmfService().getFile(resource.getURI(), this.editingDomain);
            String fileName = file != null ? file.getFullPath().toString() : "unknown name";
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.graphiti.ui", 0, "Problems encountered in file " + fileName, new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.graphiti.ui", 0, "Problems encountered in file", new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public boolean isDirty() {
        if (this.editingDomain != null && this.editingDomain.getCommandStack() != null) {
            return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
        }
        return false;
    }

    public Resource[] doSave(IProgressMonitor progressMonitor) {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        final HashSet savedResources = new HashSet();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    savedResources.addAll(GraphitiUiInternal.getEmfService().save(DiagramEditorBehavior.this.editingDomain));
                }
                catch (WrappedException e) {
                    MultiStatus errorStatus = new MultiStatus("org.eclipse.graphiti.ui", 0, e.getMessage(), (Throwable)e.exception());
                    GraphitiUIPlugin.getDefault().getLog().log((IStatus)errorStatus);
                    T.racer().error(e.getMessage(), e.exception());
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            if (this.dirtyStateUpdater != null) {
                this.dirtyStateUpdater.run();
            }
        }
        catch (Exception exception) {
            T.racer().error(exception.getMessage(), exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
        return savedResources.toArray(new Resource[savedResources.size()]);
    }

    private IOperationHistory getOperationHistory() {
        IWorkspaceCommandStack commandStack;
        IOperationHistory history = null;
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null && (commandStack = (IWorkspaceCommandStack)this.getEditingDomain().getCommandStack()) != null) {
            history = commandStack.getOperationHistory();
        }
        return history;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.init(site, editorInput, null);
    }

    public void init(IEditorSite site, IEditorInput editorInput, Runnable dirtyStateUpdater) {
        this.dirtyStateUpdater = dirtyStateUpdater;
        EObject object = (EObject)editorInput.getAdapter(EObject.class);
        TransactionalEditingDomain ed = (TransactionalEditingDomain)editorInput.getAdapter(TransactionalEditingDomain.class);
        this.initializeEditingDomain(ed);
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        if (object != null) {
            this.elementDeleteListener = new ElementDeleteListener();
            object.eAdapters().add((Object)this.elementDeleteListener);
        }
        this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
    }

    public void dispose() {
        this.updateProblemIndication = false;
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.resourceSetUpdateAdapter);
        this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
        for (Resource r : this.editingDomain.getResourceSet().getResources()) {
            r.eAdapters().remove((Object)this.updateAdapter);
        }
        EObject object = (EObject)this.editorPart.getEditorInput().getAdapter(EObject.class);
        if (object != null) {
            object.eAdapters().remove((Object)this.elementDeleteListener);
        }
        this.workspaceSynchronizer.dispose();
        IEditorInput editorInput = this.editorPart.getEditorInput();
        if (editorInput instanceof DiagramEditorInput) {
            ((DiagramEditorInput)editorInput).dispose();
        }
        this.editingDomain = null;
        this.editorPart = null;
    }

    public void setFocus() {
        this.handleActivate();
    }

    public void historyNotification(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 4: {
                ResourceSet resourceSet;
                Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
                TransactionalEditingDomain editingDomain = this.getEditingDomain();
                if (editingDomain == null || (resourceSet = editingDomain.getResourceSet()) == null) break;
                EList resourcesInThisEditor = resourceSet.getResources();
                for (Resource resource : resourcesInThisEditor) {
                    if (!affectedResources.contains(resource)) continue;
                    return;
                }
                break;
            }
            case 9: 
            case 10: {
                this.dirtyStateUpdater.run();
            }
        }
    }

    public IUndoContext getUndoContext() {
        return ((IWorkspaceCommandStack)this.getEditingDomain().getCommandStack()).getDefaultUndoContext();
    }

    private void refreshEditorContent() {
        if (this.editorPart instanceof DiagramEditorInternal) {
            ((DiagramEditorInternal)this.editorPart).refreshContent();
        }
    }

    private final class ElementDeleteListener
    extends AdapterImpl {
        private ElementDeleteListener() {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof EObject;
        }

        public void notifyChanged(Notification msg) {
            IEditorInput in;
            final IEditorPart part = DiagramEditorBehavior.this.editorPart;
            if (T.racer().debug()) {
                String editorName = part.getTitle();
                T.racer().debug("Delete listener called of editor " + editorName + " with events " + msg.toString());
            }
            if ((in = part.getEditorInput()) != null) {
                final IEditorSite site = part.getEditorSite();
                if (site == null) {
                    return;
                }
                final Shell shell = site.getShell();
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DiagramEditorBehavior.this.editorPart == null) {
                            return;
                        }
                        if (shell.isDisposed()) {
                            return;
                        }
                        EObject obj = null;
                        try {
                            obj = (EObject)in.getAdapter(EObject.class);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (obj == null || EcoreUtil.getRootContainer((EObject)obj) == null) {
                            IWorkbenchPage page = site.getPage();
                            if (T.racer().debug()) {
                                String editorName = part.getTitle();
                                T.racer().debug("Closing editor " + editorName);
                            }
                            page.closeEditor(part, false);
                        }
                    }
                });
            }
        }
    }

    private final class ResourceSetUpdateAdapter
    extends AdapterImpl {
        private ResourceSetUpdateAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(ResourceSet.class) == 0) {
                switch (msg.getEventType()) {
                    case 3: {
                        ((Resource)msg.getNewValue()).eAdapters().add((Object)DiagramEditorBehavior.this.updateAdapter);
                        break;
                    }
                    case 5: {
                        for (Resource res : (Collection)msg.getNewValue()) {
                            res.eAdapters().add((Object)DiagramEditorBehavior.this.updateAdapter);
                        }
                        break;
                    }
                    case 4: {
                        ((Resource)msg.getOldValue()).eAdapters().remove((Object)DiagramEditorBehavior.this.updateAdapter);
                        break;
                    }
                    case 6: {
                        for (Resource res : (Collection)msg.getOldValue()) {
                            res.eAdapters().remove((Object)DiagramEditorBehavior.this.updateAdapter);
                        }
                        break;
                    }
                }
            }
        }
    }
}

