/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ChopboxAnchorFixed
extends ChopboxAnchor {
    public ChopboxAnchorFixed(IFigure figure) {
        super(figure);
    }

    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute((Translatable)r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float max = Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        if (max <= 0.001f) {
            return new Point((int)centerX, r.y);
        }
        float scale = 0.5f / max;
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }
}

