/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class TransparentGhostFigure
extends ImageFigure {
    private IFigure figure = null;
    private int alpha;
    private double zoomLevel = 1.0;

    public TransparentGhostFigure(IFigure figure, int alpha, double zoomLevel) {
        this.figure = figure;
        this.alpha = alpha;
        this.zoomLevel = zoomLevel;
        this.setOpaque(false);
    }

    private Image generateImage() {
        if (this.figure == null) {
            return null;
        }
        Rectangle bounds = this.figure instanceof HandleBounds ? ((HandleBounds)this.figure).getHandleBounds().getCopy() : this.figure.getBounds().getCopy();
        bounds.scale(this.zoomLevel);
        Image image = new Image((Device)Display.getCurrent(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        swtGraphics.translate(-bounds.x, -bounds.y);
        swtGraphics.scale(this.zoomLevel);
        this.figure.paint((Graphics)swtGraphics);
        ImageData data = image.getImageData();
        data.alpha = this.alpha;
        image.dispose();
        swtGraphics.dispose();
        gc.dispose();
        return new Image((Device)Display.getCurrent(), data);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setAlpha(this.alpha);
        graphics.setBackgroundColor(ColorConstants.lightGray);
        graphics.fillRectangle(this.getClientArea().getCropped(new Insets(0, 0, 1, 1)));
        graphics.setAlpha(255);
        graphics.setLineStyle(3);
        graphics.drawRectangle(this.getClientArea().getCropped(new Insets(0, 0, 1, 1)));
    }

    public void dispose() {
        if (this.getImage() != null) {
            this.getImage().dispose();
        }
    }
}

