/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts.directedit;

import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.func.IProposal;
import org.eclipse.graphiti.func.IProposalSupport;
import org.eclipse.graphiti.ui.internal.parts.directedit.IDirectEditHolder;
import org.eclipse.graphiti.ui.internal.parts.directedit.TextCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Control;

public class GFCellEditorValidator
implements ICellEditorValidator {
    private IDirectEditHolder directEditHolder;
    private CellEditor cellEditor;

    public GFCellEditorValidator(IDirectEditHolder directEditHolder, CellEditor cellEditor) {
        this.directEditHolder = directEditHolder;
        this.setCellEditor(cellEditor);
    }

    public String isValid(Object value) {
        if (!this.directEditHolder.isSimpleMode()) {
            return this.isValidProposal(value);
        }
        String ret = null;
        if (value instanceof String) {
            ret = this.directEditHolder.getDirectEditingFeature().checkValueValid((String)value, this.directEditHolder.getDirectEditingContext());
        } else if (value instanceof Integer && this.getCellEditor() instanceof ComboBoxCellEditor) {
            ComboBoxCellEditor cb = (ComboBoxCellEditor)this.getCellEditor();
            String sValue = null;
            int index = (Integer)value;
            if (index < 0) {
                Control control = cb.getControl();
                if (control instanceof CCombo) {
                    CCombo cc = (CCombo)control;
                    sValue = cc.getText();
                }
            } else {
                String[] items = cb.getItems();
                if (items != null && index < items.length) {
                    sValue = items[index];
                }
            }
            if (sValue != null) {
                ret = this.directEditHolder.getDirectEditingFeature().checkValueValid(sValue, this.directEditHolder.getDirectEditingContext());
            }
        }
        return ret;
    }

    public String isValidProposal(Object value) {
        IProposal proposal = null;
        String text = null;
        IDirectEditingFeature directEditingFeature = this.directEditHolder.getDirectEditingFeature();
        IDirectEditingContext directEditingContext = this.directEditHolder.getDirectEditingContext();
        IProposalSupport proposalSupport = directEditingFeature.getProposalSupport();
        if (value instanceof String && this.getCellEditor() instanceof TextCellEditor) {
            text = (String)value;
            TextCellEditor tce = (TextCellEditor)this.getCellEditor();
            proposal = tce.getAcceptedProposal();
        } else if (value instanceof Integer && this.getCellEditor() instanceof ComboBoxCellEditor) {
            ComboBoxCellEditor cb = (ComboBoxCellEditor)this.getCellEditor();
            int index = (Integer)value;
            if (index < 0) {
                Control control = cb.getControl();
                if (control instanceof CCombo) {
                    CCombo cc = (CCombo)control;
                    text = cc.getText();
                }
            } else {
                proposal = proposalSupport.getPossibleValues(directEditingContext)[index];
            }
        }
        return proposalSupport.checkValueValid(text, proposal, directEditingContext);
    }

    private CellEditor getCellEditor() {
        return this.cellEditor;
    }

    private void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }
}

