/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.func.IProposal;
import org.eclipse.graphiti.internal.command.DirectEditingFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.util.LookManager;
import org.eclipse.graphiti.ui.internal.IResourceRegistryHolder;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.parts.directedit.IDirectEditHolder;
import org.eclipse.graphiti.ui.internal.parts.directedit.TextCellEditor;
import org.eclipse.graphiti.ui.internal.requests.GFDirectEditRequest;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DefaultDirectEditPolicy
extends DirectEditPolicy {
    private final IConfigurationProvider configurationProvider;

    public DefaultDirectEditPolicy(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Command getDirectEditCommand(DirectEditRequest request) {
        if (!(request instanceof GFDirectEditRequest)) {
            return null;
        }
        CellEditor cellEditor = request.getCellEditor();
        String message = cellEditor.getErrorMessage();
        if (message != null && message.length() != 0) {
            MessageDialog.openError((Shell)GraphitiUiInternal.getWorkbenchService().getShell(), (String)Messages.DefaultDirectEditPolicy_0_xmsg, (String)message);
            return null;
        }
        IDirectEditHolder directEditHolder = ((GFDirectEditRequest)request).getDirectEditHolder();
        IDirectEditingFeature directEditingFeature = directEditHolder.getDirectEditingFeature();
        IDirectEditingContext directEditingContext = directEditHolder.getDirectEditingContext();
        String value = null;
        IProposal acceptedProposal = null;
        if (cellEditor instanceof TextCellEditor) {
            TextCellEditor tce = (TextCellEditor)cellEditor;
            value = (String)tce.getValue();
            acceptedProposal = tce.getAcceptedProposal();
        } else if (cellEditor instanceof ComboBoxCellEditor) {
            int index = (Integer)cellEditor.getValue();
            if (index < 0) {
                Control control = cellEditor.getControl();
                if (!(control instanceof CCombo)) return null;
                CCombo cc = (CCombo)control;
                value = cc.getText();
            } else if (directEditHolder.isSimpleMode()) {
                value = directEditingFeature.getPossibleValues(directEditingContext)[index];
            } else {
                acceptedProposal = directEditingFeature.getProposalSupport().getPossibleValues(directEditingContext)[index];
            }
        }
        if (value == null && acceptedProposal == null) {
            return null;
        }
        DirectEditingFeatureCommandWithContext cmd = new DirectEditingFeatureCommandWithContext(directEditingFeature, directEditingContext, value, acceptedProposal);
        IFeatureProvider fp = directEditingFeature.getFeatureProvider();
        DiagramEditorInternal diagramEditor = (DiagramEditorInternal)fp.getDiagramTypeProvider().getDiagramEditor();
        CommandStack commandStack = diagramEditor.getEditDomain().getCommandStack();
        commandStack.execute((Command)new GefCommandWrapper((ICommand)cmd, diagramEditor.getEditingDomain()));
        return null;
    }

    protected void showCurrentEditValue(DirectEditRequest request) {
        Object currentValue = request.getCellEditor().getValue();
        this.getHostFigure().getUpdateManager().performUpdate();
    }

    protected void showDirectEditFeedback(DirectEditRequest request) {
        super.showDirectEditFeedback(request);
        String errorMessage = request.getCellEditor().getErrorMessage();
        Control control = request.getCellEditor().getControl();
        if (errorMessage == null) {
            control.setBackground(ColorConstants.listBackground);
            control.setForeground(ColorConstants.listForeground);
        } else {
            IColorConstant errorBgColorConstant = LookManager.getLook().getFieldErrorBackgroundColor();
            Color errorBgColor = DataTypeTransformation.toSwtColor((IResourceRegistryHolder)this.configurationProvider, errorBgColorConstant);
            control.setBackground(errorBgColor);
            IColorConstant errorFgColorConstant = LookManager.getLook().getFieldErrorForegroundColor();
            Color errorfgColor = DataTypeTransformation.toSwtColor((IResourceRegistryHolder)this.configurationProvider, errorFgColorConstant);
            control.setForeground(errorfgColor);
        }
        GraphitiUiInternal.getWorkbenchService().getActiveStatusLineManager().setErrorMessage(errorMessage);
    }
}

