/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.examples.common.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.CommonActionProvider;

public class RenameActionProvider
extends CommonActionProvider {
    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection sel;
        Object el;
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (el = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof EClass) {
            EClass eclass = (EClass)el;
            String platformString = eclass.eResource().getURI().toPlatformString(true);
            Path path = new Path(platformString);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file == null) {
                return;
            }
            IProject project = file.getProject();
            try {
                if (!project.hasNature("org.eclipse.graphiti.examples.examplesnature")) {
                    return;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            menu.appendToGroup("additions", this.getAction(eclass));
        }
    }

    private IAction getAction(EClass eo) {
        return new RenameAction(eo);
    }

    private static class RenameAction
    extends Action {
        private EClass eclass;

        public RenameAction(EClass eo) {
            this.eclass = eo;
        }

        public void run() {
            InputDialog inputDialog = new InputDialog(null, Messages.RenameActionProvider_ProvideNameTitle, Messages.RenameActionProvider_ProvideNameDescription, this.eclass.getName(), null);
            int open = inputDialog.open();
            if (open == 0) {
                String newName = inputDialog.getValue();
                Resource resource = this.eclass.eResource();
                ResourceSet resourceSet = resource.getResourceSet();
                TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
                try {
                    if (domain != null) {
                        Command setCommand = domain.createCommand(SetCommand.class, new CommandParameter((Object)this.eclass, (Object)EcorePackage.Literals.ENAMED_ELEMENT__NAME, (Object)newName));
                        domain.getCommandStack().execute(setCommand);
                        try {
                            resource.save(Collections.emptyMap());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    domain.dispose();
                }
            }
        }

        public String getText() {
            return Messages.RenameActionProvider_RenameEClassText;
        }
    }
}

