/**
 * <copyright>
 * 
 * Copyright (c) 2012, 2012 SAP AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Benjamin Schmeling - initial API, implementation and documentation for Bug 367483
 * 
 * </copyright>
 */
package org.eclipse.graphiti.mm.pictograms;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Composite Connection</b></em>'. <br>
 * <b>Note that this is an experimental API and might change without further
 * notice.</b> @experimental
 * 
 * @since 0.9<!-- end-user-doc -->
 * 
 *        <p>
 *        The following features are supported:
 *        <ul>
 *        <li>
 *        {@link org.eclipse.graphiti.mm.pictograms.CompositeConnection#getChildren
 *        <em>Children</em>}</li>
 *        </ul>
 *        </p>
 * 
 * @see org.eclipse.graphiti.mm.pictograms.PictogramsPackage#getCompositeConnection()
 * @model
 * @generated
 */
public interface CompositeConnection extends Connection {
	/**
	 * Returns the value of the '<em><b>Children</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.graphiti.mm.pictograms.CurvedConnection}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Children</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Children</em>' reference list.
	 * @see org.eclipse.graphiti.mm.pictograms.PictogramsPackage#getCompositeConnection_Children()
	 * @model
	 * @generated
	 */
	EList<CurvedConnection> getChildren();

} // CompositeConnection
