/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.dt;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.notification.DefaultNotificationService;
import org.eclipse.graphiti.notification.INotificationService;
import org.eclipse.graphiti.platform.AbstractExtension;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRendererFactory;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;

public abstract class AbstractDiagramTypeProvider
extends AbstractExtension
implements IDiagramTypeProvider {
    private IToolBehaviorProvider[] availableToolBehaviorProviders = null;
    private Diagram diagram;
    private IDiagramBehavior diagramBehavior;
    private IFeatureProvider featureProvider;
    private INotificationService notificationService;
    private int currentToolBehaviorIndex = 0;
    private String contextId;

    @Override
    public IToolBehaviorProvider[] getAvailableToolBehaviorProviders() {
        if (this.availableToolBehaviorProviders == null) {
            this.availableToolBehaviorProviders = new IToolBehaviorProvider[]{new DefaultToolBehaviorProvider(this)};
        }
        return this.availableToolBehaviorProviders;
    }

    @Override
    public IToolBehaviorProvider getCurrentToolBehaviorProvider() {
        IToolBehaviorProvider ret = null;
        if (this.getAvailableToolBehaviorProviders().length > 0) {
            ret = this.getAvailableToolBehaviorProviders()[this.getCurrentToolBehaviorIndex()];
        }
        return ret;
    }

    @Override
    public int getCurrentToolBehaviorIndex() {
        return this.currentToolBehaviorIndex;
    }

    @Override
    public void setCurrentToolBehaviorIndex(int index) {
        if (this.currentToolBehaviorIndex != index) {
            if (index < 0 || index >= this.getAvailableToolBehaviorProviders().length) {
                throw new IllegalArgumentException("Index not valid");
            }
            this.currentToolBehaviorIndex = index;
            IDiagramBehavior diagramBehavior = this.getDiagramBehavior();
            diagramBehavior.refresh();
            diagramBehavior.refreshPalette();
        }
    }

    @Override
    public Diagram getDiagram() {
        return this.diagram;
    }

    @Override
    public String getDiagramTitle() {
        String name = "";
        if (this.getDiagram() != null) {
            name = this.getDiagram().getName();
        }
        return name;
    }

    @Override
    public IDiagramEditor getDiagramEditor() {
        return this.getDiagramBehavior().getDiagramContainer();
    }

    @Override
    public IDiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }

    @Override
    public IFeatureProvider getFeatureProvider() {
        if (this.featureProvider == null) {
            T.racer().error("featureProvider is null");
        }
        return this.featureProvider;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @Override
    public void init(Diagram diagram, IDiagramEditor diagramEditor) {
        this.setAndWireDiagram(diagram);
        this.setDiagramBehavior(((IDiagramContainer)diagramEditor).getDiagramBehavior());
    }

    @Override
    public void init(Diagram diagram, IDiagramBehavior diagramBehavior) {
        this.setAndWireDiagram(diagram);
        this.setDiagramBehavior(diagramBehavior);
    }

    private void setDiagramBehavior(IDiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    private void setAndWireDiagram(Diagram diagram) {
        this.diagram = diagram;
        GraphitiInternal.getEmfService().wireDTPToDiagram(diagram, this);
    }

    protected void setFeatureProvider(IFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    @Override
    public boolean isAutoUpdateAtRuntime() {
        return true;
    }

    @Override
    public boolean isAutoUpdateAtRuntimeWhenEditorIsSaved() {
        return false;
    }

    @Override
    public boolean isAutoUpdateAtStartup() {
        return false;
    }

    @Override
    public boolean isAutoUpdateAtReset() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.getCurrentToolBehaviorProvider() != null) {
            this.getCurrentToolBehaviorProvider().dispose();
        }
        if (this.getFeatureProvider() != null) {
            this.getFeatureProvider().dispose();
        }
    }

    @Override
    public INotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = new DefaultNotificationService(this);
        }
        return this.notificationService;
    }

    @Override
    public Object[] getRelatedBusinessObjects(Object[] bos) {
        return new Object[0];
    }

    @Override
    public IGraphicsAlgorithmRendererFactory getGraphicsAlgorithmRendererFactory() {
        return null;
    }

    @Override
    public void postInit() {
    }

    @Override
    public void resourceReloaded(Diagram diagram) {
        this.setAndWireDiagram(diagram);
    }

    @Override
    public void resourcesSaved(Diagram diagram, Resource[] savedResources) {
    }
}

