/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import org.eclipse.graphiti.features.ICustomAbortableUndoRedoFeature;
import org.eclipse.graphiti.features.ICustomUndoableFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.pattern.FeatureForPatternDelegate;
import org.eclipse.graphiti.pattern.ICustomAbortableUndoRedoPattern;
import org.eclipse.graphiti.pattern.ICustomUndoRedoPattern;
import org.eclipse.graphiti.pattern.ICustomUndoablePattern;
import org.eclipse.graphiti.pattern.IFeatureForPattern;
import org.eclipse.graphiti.pattern.IPattern;

public class LayoutFeatureForPattern
extends AbstractLayoutFeature
implements ICustomUndoableFeature,
ICustomAbortableUndoRedoFeature {
    private IFeatureForPattern delegate;

    public LayoutFeatureForPattern(IFeatureProvider featureProvider, IPattern pattern) {
        super(featureProvider);
        this.delegate = new FeatureForPatternDelegate(pattern);
    }

    public boolean canLayout(ILayoutContext context) {
        IPattern pattern = this.delegate.getPattern();
        return pattern.canLayout(context);
    }

    public boolean layout(ILayoutContext context) {
        return this.delegate.getPattern().layout(context);
    }

    public boolean isAbort() {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomAbortableUndoRedoPattern) {
            return ((ICustomAbortableUndoRedoPattern)((Object)pattern)).isAbort();
        }
        return false;
    }

    public boolean canUndo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            return ((ICustomUndoablePattern)((Object)pattern)).canUndo((IFeature)this, context);
        }
        return super.canUndo(context);
    }

    public void preUndo(IContext context) {
    }

    public void postUndo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoRedoPattern) {
            ((ICustomUndoRedoPattern)((Object)pattern)).postUndo((IFeature)this, context);
        }
    }

    public void undo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            ((ICustomUndoablePattern)((Object)pattern)).undo((IFeature)this, context);
        }
    }

    public boolean canRedo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            return ((ICustomUndoablePattern)((Object)pattern)).canRedo((IFeature)this, context);
        }
        return true;
    }

    public void preRedo(IContext context) {
    }

    public void postRedo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoRedoPattern) {
            ((ICustomUndoRedoPattern)((Object)pattern)).postRedo((IFeature)this, context);
        }
    }

    public void redo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            ((ICustomUndoablePattern)((Object)pattern)).redo((IFeature)this, context);
        }
    }
}

