/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.Map;
import java.util.Stack;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.workspace.impl.WorkspaceCommandStackImpl;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.ICustomAbortableUndoRedoFeature;
import org.eclipse.graphiti.features.ICustomUndoRedoFeature;
import org.eclipse.graphiti.features.ICustomUndoableFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.DefaultExecutionInfo;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;

public class GFWorkspaceCommandStackImpl
extends WorkspaceCommandStackImpl {
    private Stack<IExecutionInfo> undoStackForExecutionInfo = new Stack();
    private Stack<IExecutionInfo> redoStackForExecutionInfo = new Stack();

    public GFWorkspaceCommandStackImpl(IOperationHistory history) {
        super(history);
    }

    public synchronized void execute(Command command, Map<?, ?> options) throws InterruptedException, RollbackException {
        InternalTransaction activeTransaction;
        boolean usableTransactionExists;
        Object object;
        IExecutionInfo executionInfo = null;
        if (options != null && (object = options.get("org.eclipse.graphiti.execution.info")) instanceof IExecutionInfo) {
            executionInfo = (IExecutionInfo)object;
            options.remove("org.eclipse.graphiti.execution.info");
        }
        boolean bl = usableTransactionExists = (activeTransaction = this.getDomain().getActiveTransaction()) != null && !activeTransaction.isReadOnly() && activeTransaction.getOwner().equals(Thread.currentThread());
        if (!usableTransactionExists) {
            super.execute(command, options);
            if (executionInfo == null) {
                executionInfo = new DefaultExecutionInfo();
                GraphitiUiInternal.getCommandService().completeExecutionInfo((DefaultExecutionInfo)executionInfo, GraphitiUiInternal.getCommandService().transformFromEmfToGefCommand(command));
            }
            if ((executionInfo = GraphitiUiInternal.getCommandService().removeFeaturesWithoutChanges(executionInfo)).getExecutionList().length > 0) {
                this.undoStackForExecutionInfo.push(executionInfo);
            }
        } else {
            command.execute();
            if (this.getMostRecentCommand() != null) {
                this.getMostRecentCommand().chain(command);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.redoStackForExecutionInfo.clear();
        this.redoStackForExecutionInfo = null;
        this.undoStackForExecutionInfo.clear();
        this.undoStackForExecutionInfo = null;
    }

    public void flush() {
        super.flush();
        this.undoStackForExecutionInfo.clear();
        this.redoStackForExecutionInfo.clear();
    }

    public void redo() {
        ICustomUndoRedoFeature undoableFeature;
        IContext context;
        IFeatureAndContext[] executionList = null;
        boolean[] canRedo = null;
        if (!this.redoStackForExecutionInfo.isEmpty()) {
            IExecutionInfo ei = this.redoStackForExecutionInfo.pop();
            this.undoStackForExecutionInfo.push(ei);
            executionList = ei.getExecutionList();
            canRedo = new boolean[executionList.length];
            int i = 0;
            while (i < executionList.length) {
                IFeature feature = executionList[i].getFeature();
                IContext context2 = executionList[i].getContext();
                canRedo[i] = feature instanceof ICustomUndoRedoFeature ? ((ICustomUndoRedoFeature)feature).canRedo(context2) : false;
                ++i;
            }
        }
        if (executionList != null) {
            int i = executionList.length - 1;
            while (i >= 0) {
                IFeature feature = executionList[i].getFeature();
                context = executionList[i].getContext();
                if (feature instanceof ICustomUndoRedoFeature) {
                    undoableFeature = (ICustomUndoRedoFeature)feature;
                    if (canRedo[i]) {
                        undoableFeature.preRedo(context);
                        if (undoableFeature instanceof ICustomAbortableUndoRedoFeature && ((ICustomAbortableUndoRedoFeature)undoableFeature).isAbort()) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                --i;
            }
        }
        if (super.canRedo()) {
            super.redo();
        }
        if (executionList != null) {
            int i = 0;
            while (i < executionList.length) {
                IFeature feature = executionList[i].getFeature();
                context = executionList[i].getContext();
                if (feature instanceof ICustomUndoableFeature && (undoableFeature = (ICustomUndoableFeature)feature).canRedo(context)) {
                    undoableFeature.redo(context);
                }
                ++i;
            }
            i = 0;
            while (i < executionList.length) {
                IFeature feature = executionList[i].getFeature();
                context = executionList[i].getContext();
                if (feature instanceof ICustomUndoRedoFeature) {
                    undoableFeature = (ICustomUndoRedoFeature)feature;
                    if (canRedo[i]) {
                        undoableFeature.postRedo(context);
                    }
                }
                ++i;
            }
        }
    }

    public void undo() {
        ICustomUndoRedoFeature undoableFeature;
        IContext context;
        IFeatureAndContext[] executionList = null;
        boolean[] canUndo = null;
        if (!this.undoStackForExecutionInfo.isEmpty()) {
            IExecutionInfo ei = this.undoStackForExecutionInfo.pop();
            this.redoStackForExecutionInfo.push(ei);
            executionList = ei.getExecutionList();
            canUndo = new boolean[executionList.length];
            int i = 0;
            while (i < executionList.length) {
                IFeature feature = executionList[i].getFeature();
                IContext context2 = executionList[i].getContext();
                canUndo[i] = feature instanceof ICustomUndoRedoFeature ? feature.canUndo(context2) : false;
                ++i;
            }
        }
        if (executionList != null) {
            int i = executionList.length - 1;
            while (i >= 0) {
                IFeature feature = executionList[i].getFeature();
                context = executionList[i].getContext();
                if (feature instanceof ICustomUndoRedoFeature) {
                    undoableFeature = (ICustomUndoRedoFeature)feature;
                    if (canUndo[i]) {
                        undoableFeature.preUndo(context);
                        if (undoableFeature instanceof ICustomAbortableUndoRedoFeature && ((ICustomAbortableUndoRedoFeature)undoableFeature).isAbort()) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                --i;
            }
        }
        if (super.canUndo()) {
            super.undo();
        }
        if (executionList != null) {
            int i = executionList.length - 1;
            while (i >= 0) {
                IFeature feature = executionList[i].getFeature();
                context = executionList[i].getContext();
                if (feature instanceof ICustomUndoableFeature && (undoableFeature = (ICustomUndoableFeature)feature).canUndo(context)) {
                    undoableFeature.undo(context);
                }
                --i;
            }
            i = executionList.length - 1;
            while (i >= 0) {
                IFeature feature = executionList[i].getFeature();
                context = executionList[i].getContext();
                if (feature instanceof ICustomUndoRedoFeature) {
                    undoableFeature = (ICustomUndoRedoFeature)feature;
                    if (canUndo[i]) {
                        undoableFeature.postUndo(context);
                    }
                }
                --i;
            }
        }
    }
}

