/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common;

import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExampleUtil {
    public static String askString(String dialogTitle, String dialogMessage, String initialValue) {
        String ret = null;
        Shell shell = ExampleUtil.getShell();
        InputDialog inputDialog = new InputDialog(shell, dialogTitle, dialogMessage, initialValue, null);
        int retDialog = inputDialog.open();
        if (retDialog == 0) {
            ret = inputDialog.getValue();
        }
        return ret;
    }

    public static Color editColor(Color color) {
        if (color != null && color.eContainer() instanceof Diagram) {
            Shell shell = ExampleUtil.getShell();
            ColorDialog colorDialog = new ColorDialog(shell);
            colorDialog.setText("Choose Color");
            colorDialog.setRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            RGB retRgb = colorDialog.open();
            if (retRgb == null) {
                return null;
            }
            Diagram diagram = (Diagram)color.eContainer();
            Color newColor = Graphiti.getGaService().manageColor(diagram, retRgb.red, retRgb.green, retRgb.blue);
            return newColor;
        }
        return null;
    }

    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

