/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.common.ExamplesCommonPlugin;
import org.eclipse.graphiti.examples.common.navigator.nodes.EClassesNode;
import org.eclipse.graphiti.examples.common.navigator.nodes.base.IContainerNode;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class GFEmfLabelProvider
extends LabelProvider {
    private static final String IMPL = "Impl";

    public String getText(Object element) {
        String ret = "";
        if (element instanceof IContainerNode) {
            IContainerNode icn = (IContainerNode)element;
            ret = icn.getText();
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getName();
        }
        if (element instanceof Diagram) {
            Diagram diagram = (Diagram)element;
            ret = this.createTextForDiagram(diagram);
        }
        if (element instanceof EClass) {
            String name = ((EClass)element).getName();
            if (name == null) {
                name = "name not available";
            }
            return name;
        }
        if (element instanceof EObject && ret.length() <= 0) {
            EObject eObject = (EObject)element;
            if ((ret = String.valueOf(ret) + eObject.getClass().getSimpleName()).endsWith(IMPL)) {
                ret = ret.substring(0, ret.length() - IMPL.length());
            }
        }
        if (element instanceof GraphicsAlgorithm && ret.length() > 0) {
            ret = String.valueOf(ret) + "   -   ";
            ret = String.valueOf(ret) + super.getText(element);
        }
        return ret;
    }

    private String createTextForDiagram(Diagram diagram) {
        return "Diagram";
    }

    public Image getImage(Object element) {
        if (element instanceof EClassesNode) {
            return this.getEClassesNodeImage();
        }
        if (element instanceof IContainerNode) {
            IContainerNode icn = (IContainerNode)element;
            return icn.getImage();
        }
        if (element instanceof IFile) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
        if (element instanceof PictogramElement) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
        if (element instanceof EClass) {
            return this.getEClassImage();
        }
        if (element instanceof EObject) {
            return this.getEObjectImage();
        }
        return super.getImage(element);
    }

    private Image getEClassImage() {
        String key;
        ImageRegistry registry = ExamplesCommonPlugin.getDefault().getImageRegistry();
        Image image = registry.get(key = "icons/full/obj16/EClass.gif");
        if (image == null) {
            ImageDescriptor desc = ExamplesCommonPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecore.edit", (String)key);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }

    private Image getEObjectImage() {
        String key;
        ImageRegistry registry = ExamplesCommonPlugin.getDefault().getImageRegistry();
        Image image = registry.get(key = "icons/full/obj16/EObject.gif");
        if (image == null) {
            ImageDescriptor desc = ExamplesCommonPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecore.edit", (String)key);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }

    private Image getEClassesNodeImage() {
        String key;
        ImageRegistry registry = ExamplesCommonPlugin.getDefault().getImageRegistry();
        Image image = registry.get(key = "icons/full/obj16/EPackage.gif");
        if (image == null) {
            ImageDescriptor desc = ExamplesCommonPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecore.edit", (String)key);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }
}

