/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.navigator.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.graphiti.examples.common.navigator.nodes.base.AbstractInstancesOfTypeContainerNode;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;

public class DiagramsNode
extends AbstractInstancesOfTypeContainerNode {
    private static final String NAME = "Diagrams";

    public DiagramsNode(Object parent, IProject project) {
        super(parent, project);
    }

    @Override
    protected String getContainerName() {
        return NAME;
    }

    @Override
    public Object[] getChildren() {
        IProject project = this.getProject();
        if (project != null) {
            ResourceSetImpl rSet = new ResourceSetImpl();
            return this.getAllDiagramFiles(project, (ResourceSet)rSet).toArray();
        }
        return null;
    }

    private List<IFile> getFiles(IContainer folder) {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    ret.addAll(this.getFiles((IContainer)resource));
                } else if (resource instanceof IFile && (file = (IFile)resource).getName().endsWith(".diagram")) {
                    ret.add(file);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private List<IFile> getAllDiagramFiles(IProject project, ResourceSet rSet) {
        List<IFile> files = this.getFiles((IContainer)project);
        ArrayList<IFile> ret = new ArrayList<IFile>();
        for (IFile file : files) {
            Diagram diagram = GraphitiUiInternal.getEmfService().getDiagramFromFile(file, rSet);
            if (diagram == null) continue;
            ret.add(file);
        }
        return ret;
    }
}

