/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.pattern.compartment;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.examples.common.pattern.compartment.DefaultCompartmentPatternConfiguration;
import org.eclipse.graphiti.examples.common.pattern.compartment.ICompartmentPatternConfiguration;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.AbstractPattern;
import org.eclipse.graphiti.pattern.config.IPatternConfiguration;
import org.eclipse.graphiti.pattern.mapping.ILinkCreationInfo;
import org.eclipse.graphiti.pattern.mapping.IStructureMapping;
import org.eclipse.graphiti.pattern.mapping.IStructureMappingMulti;
import org.eclipse.graphiti.pattern.mapping.IStructureMappingSingle;
import org.eclipse.graphiti.pattern.mapping.data.LabelDataMapping;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaCreateService;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILinkService;
import org.eclipse.graphiti.services.IPeCreateService;

public abstract class CompartmentPattern
extends AbstractPattern {
    private static final int TEXT_HEIGHT = 25;
    private IStructureMappingSingle headerMapping;
    private IStructureMappingMulti[] compartmentMappings;

    public CompartmentPattern() {
        super((IPatternConfiguration)new DefaultCompartmentPatternConfiguration());
    }

    public PictogramElement add(IAddContext context) {
        Text text;
        Object mainBusinessObject = context.getNewObject();
        ContainerShape parentContainerShape = context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaCreateService gaCreateService = Graphiti.getGaCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape(parentContainerShape, true);
        this.getFeatureProvider().getDirectEditingInfo().setMainPictogramElement((PictogramElement)containerShape);
        int width = context.getWidth() <= 0 ? 100 : context.getWidth();
        int height = context.getHeight() <= 0 ? 120 : context.getHeight();
        RoundedRectangle roundedRectangle = gaCreateService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, this.getConfiguration().getCornerWidth(), this.getConfiguration().getCornerHeight());
        roundedRectangle.setForeground(this.manageColor(this.getConfiguration().getForegroundColor()));
        roundedRectangle.setBackground(this.manageColor(this.getConfiguration().getBackgroundColor()));
        roundedRectangle.setLineWidth(Integer.valueOf(this.getConfiguration().getLineWidth()));
        roundedRectangle.setTransparency(Double.valueOf(this.getConfiguration().getTransparency()));
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)roundedRectangle, context.getX(), context.getY(), width, height);
        this.link((PictogramElement)containerShape, mainBusinessObject);
        Shape shape = peCreateService.createShape(containerShape, false);
        if (this.getConfiguration().isHeaderImageVisible()) {
            Rectangle rectangle = gaCreateService.createRectangle((GraphicsAlgorithmContainer)shape);
            rectangle.setFilled(Boolean.valueOf(false));
            rectangle.setLineVisible(Boolean.valueOf(false));
            gaCreateService.createImage((GraphicsAlgorithmContainer)rectangle, "org.eclipse.graphiti.edit.expandall");
            text = gaCreateService.createDefaultText((GraphicsAlgorithmContainer)rectangle);
            text.setForeground(this.manageColor(this.getConfiguration().getTextColor()));
            text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            text.getFont().setBold(true);
        } else {
            text = gaCreateService.createDefaultText((GraphicsAlgorithmContainer)shape);
            text.setForeground(this.manageColor(this.getConfiguration().getTextColor()));
            text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            text.getFont().setBold(true);
        }
        IDirectEditingInfo dei = this.getFeatureProvider().getDirectEditingInfo();
        dei.setPictogramElement((PictogramElement)shape);
        dei.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        ILinkCreationInfo linkCreationInfo = this.getHeaderMapping().getLinkCreationInfo(mainBusinessObject);
        String linkProperty = linkCreationInfo.getProperty();
        if (linkProperty != null) {
            this.getLinkService().setLinkProperty((PictogramElement)shape, linkProperty);
        }
        this.link((PictogramElement)shape, linkCreationInfo.getBusinessObjects());
        int compartmentIndex = 0;
        while (compartmentIndex < this.getCompartmentCount()) {
            Shape shape2 = peCreateService.createShape(containerShape, false);
            Polyline polyline = gaCreateService.createPolyline((GraphicsAlgorithmContainer)shape2, new int[4]);
            polyline.setForeground(this.manageColor(this.getConfiguration().getForegroundColor()));
            polyline.setLineWidth(Integer.valueOf(this.getConfiguration().getLineWidth()));
            ContainerShape compartmentContainerShape = peCreateService.createContainerShape(containerShape, false);
            Rectangle compartmentRectangle = gaCreateService.createRectangle((GraphicsAlgorithmContainer)compartmentContainerShape);
            compartmentRectangle.setFilled(Boolean.valueOf(false));
            compartmentRectangle.setLineVisible(Boolean.valueOf(false));
            ++compartmentIndex;
        }
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        this.updatePictogramElement((PictogramElement)containerShape);
        return containerShape;
    }

    protected void activateHeaderTextAutoDirectEditing() {
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
    }

    public boolean layout(ILayoutContext context) {
        ContainerShape lastCompartmentCs;
        Object lastCompartment;
        int minimumWidth;
        boolean ret = false;
        IGaService gaService = Graphiti.getGaService();
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        int continousY = this.getConfiguration().getOuterIndentTop();
        EList containerShapeChildren = containerShape.getChildren();
        int containerWidth = containerShape.getGraphicsAlgorithm().getWidth();
        if (containerWidth < (minimumWidth = this.getConfiguration().getMinimumWidth())) {
            containerShape.getGraphicsAlgorithm().setWidth(minimumWidth);
            containerWidth = minimumWidth;
            ret = true;
        }
        int innerWidth = containerWidth - this.getConfiguration().getOuterIndentLeft() - this.getConfiguration().getOuterIndentRight();
        for (Shape shape : containerShapeChildren) {
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            if (ga instanceof Polyline) {
                Polyline pl = (Polyline)ga;
                EList points = pl.getPoints();
                int x0 = ((Point)points.get(0)).getX();
                points.set(0, gaService.createPoint(x0, continousY));
                points.set(1, gaService.createPoint(containerWidth, continousY));
                continue;
            }
            if (shape instanceof ContainerShape) {
                ContainerShape compartmentContainerShape = (ContainerShape)shape;
                compartmentContainerShape.getGraphicsAlgorithm().setY(continousY);
                int innerY = 0;
                for (Shape innerCompartmentShape : compartmentContainerShape.getChildren()) {
                    GraphicsAlgorithm innerGa = innerCompartmentShape.getGraphicsAlgorithm();
                    gaService.setLocationAndSize(innerGa, 0, innerY, innerWidth, 25);
                    GraphicsAlgorithm imageGa = (GraphicsAlgorithm)innerGa.getGraphicsAlgorithmChildren().get(0);
                    gaService.setLocationAndSize(imageGa, 0, 0, 25, 25);
                    GraphicsAlgorithm textGa = (GraphicsAlgorithm)innerGa.getGraphicsAlgorithmChildren().get(1);
                    gaService.setLocationAndSize(textGa, 25, 0, innerWidth - 25, 25);
                    innerY += 25;
                }
                int compartmentHeight = compartmentContainerShape.getChildren().size() * 25;
                gaService.setLocationAndSize(compartmentContainerShape.getGraphicsAlgorithm(), this.getConfiguration().getOuterIndentLeft(), continousY, innerWidth, compartmentHeight, true);
            } else {
                gaService.setLocationAndSize(shape.getGraphicsAlgorithm(), this.getConfiguration().getOuterIndentLeft(), this.getConfiguration().getOuterIndentTop(), innerWidth, 25);
                if (this.getConfiguration().isHeaderImageVisible()) {
                    GraphicsAlgorithm imageGa = (GraphicsAlgorithm)ga.getGraphicsAlgorithmChildren().get(0);
                    GraphicsAlgorithm textGa = (GraphicsAlgorithm)ga.getGraphicsAlgorithmChildren().get(1);
                    gaService.setLocationAndSize(imageGa, 0, 0, 25, 25);
                    gaService.setLocationAndSize(textGa, 25, 0, innerWidth - 25, 25);
                }
            }
            continousY += gaService.calculateSize(ga).getHeight();
        }
        int additionalHeight = 0;
        int compartmentCount = containerShapeChildren.size();
        if (compartmentCount >= 1 && (lastCompartment = containerShapeChildren.get(compartmentCount - 1)) instanceof ContainerShape && (lastCompartmentCs = (ContainerShape)lastCompartment).getChildren().size() == 0) {
            additionalHeight = this.getConfiguration().getCornerHeight() / 2;
        }
        int containerHeight = containerShape.getGraphicsAlgorithm().getHeight();
        int newHeight = Math.max(containerHeight, continousY + additionalHeight + this.getConfiguration().getOuterIndentBottom());
        if (containerHeight != (newHeight = Math.max(newHeight, this.getConfiguration().getMinimumHeight()))) {
            containerShape.getGraphicsAlgorithm().setHeight(newHeight);
            ret = true;
        }
        return ret;
    }

    public boolean update(IUpdateContext context) {
        boolean ret = false;
        PictogramElement pe = context.getPictogramElement();
        if (this.isPatternRoot(pe)) {
            ret = this.updateAndLayoutRoot((ContainerShape)pe);
        } else {
            ContainerShape rootContainer = this.getPatternRoot(pe);
            if (rootContainer != null) {
                ret = this.updateAndLayoutRoot(rootContainer);
            }
        }
        return ret;
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (this.isPatternRoot(pe)) {
            ContainerShape outerContainerShape = (ContainerShape)pe;
            if (!(this.getHeaderMapping().getDataMapping() instanceof LabelDataMapping)) {
                Shape textShape = (Shape)outerContainerShape.getChildren().get(0);
                PictogramLink linkForPictogramElement = this.getLinkService().getLinkForPictogramElement((PictogramElement)textShape);
                if (linkForPictogramElement != null) {
                    GraphicsAlgorithm ga = textShape.getGraphicsAlgorithm();
                    String currentValue = ((Text)ga).getValue();
                    String value = this.getText((IStructureMapping)this.getHeaderMapping(), linkForPictogramElement);
                    if (currentValue == null || !currentValue.equals(value)) {
                        return Reason.createTrueReason((String)this.getHeaderMapping().getDataMapping().getUpdateWarning(linkForPictogramElement));
                    }
                }
            }
            Object mainBusinessObject = this.getBusinessObjectForPictogramElement((PictogramElement)outerContainerShape);
            int compartmentIndex = 0;
            while (compartmentIndex < this.getCompartmentCount()) {
                IStructureMappingMulti mapping;
                IReason ret;
                ContainerShape compartmentContainerShape = (ContainerShape)outerContainerShape.getChildren().get((compartmentIndex + 1) * 2);
                if (compartmentContainerShape != null && (ret = this.updateCompartmentNeeded(compartmentContainerShape, mainBusinessObject, mapping = this.getCompartmentMapping(compartmentIndex))).toBoolean()) {
                    return ret;
                }
                ++compartmentIndex;
            }
        }
        return Reason.createFalseReason();
    }

    protected abstract IStructureMappingMulti[] createCompartmentMappings();

    protected abstract IStructureMappingSingle createHeaderMapping();

    private void createShapesInCompartment(ContainerShape compartmentContainerShape, List<ILinkCreationInfo> linkCreationInfos) {
        IGaCreateService gaCreateService = Graphiti.getGaCreateService();
        for (ILinkCreationInfo linkCreationInfo : linkCreationInfos) {
            Shape shape = Graphiti.getPeCreateService().createShape(compartmentContainerShape, false);
            Rectangle rectangle = gaCreateService.createRectangle((GraphicsAlgorithmContainer)shape);
            rectangle.setFilled(Boolean.valueOf(false));
            rectangle.setLineVisible(Boolean.valueOf(false));
            gaCreateService.createImage((GraphicsAlgorithmContainer)rectangle, "org.eclipse.graphiti.edit.expandall");
            Text text = gaCreateService.createDefaultText((GraphicsAlgorithmContainer)rectangle);
            text.setForeground(this.manageColor(this.getConfiguration().getTextColor()));
            text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            text.getFont().setBold(true);
            Object[] businessObjects = linkCreationInfo.getBusinessObjects();
            this.link((PictogramElement)shape, businessObjects);
            String linkProperty = linkCreationInfo.getProperty();
            if (linkProperty == null) continue;
            this.getLinkService().setLinkProperty((PictogramElement)shape, linkProperty);
        }
    }

    private int getCompartmentCount() {
        return this.getCompartmentMappings().length;
    }

    private IStructureMappingMulti getCompartmentMapping(int index) {
        return this.getCompartmentMappings()[index];
    }

    private IStructureMappingMulti[] getCompartmentMappings() {
        if (this.compartmentMappings == null) {
            this.compartmentMappings = this.createCompartmentMappings();
        }
        return this.compartmentMappings;
    }

    private IStructureMappingSingle getHeaderMapping() {
        if (this.headerMapping == null) {
            this.headerMapping = this.createHeaderMapping();
        }
        return this.headerMapping;
    }

    private ContainerShape getPatternRoot(PictogramElement pe) {
        ContainerShape ret = null;
        if (pe == null || pe.eResource() == null) {
            return ret;
        }
        int i = 0;
        do {
            if (this.isPatternRoot(pe)) {
                ret = (ContainerShape)pe;
                continue;
            }
            if (!(pe instanceof Shape)) continue;
            pe = ((Shape)pe).getContainer();
        } while (ret == null && ++i < 3);
        return ret;
    }

    private boolean isCompartment(PictogramElement pe) {
        boolean ret = false;
        if (pe instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pe;
            ContainerShape container = cs.getContainer();
            ret = this.isPatternRoot((PictogramElement)container);
        }
        return ret;
    }

    private boolean isCompartmentEntry(PictogramElement pe) {
        boolean ret = false;
        if (pe instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pe;
            ContainerShape container = cs.getContainer();
            ret = this.isCompartment((PictogramElement)container);
        }
        return ret;
    }

    private boolean isHeader(PictogramElement pe) {
        Shape shape;
        GraphicsAlgorithm ga;
        boolean ret = false;
        if (pe instanceof Shape && (ga = (shape = (Shape)pe).getGraphicsAlgorithm()) instanceof Text) {
            ContainerShape container = shape.getContainer();
            ret = this.isPatternRoot((PictogramElement)container);
        }
        return ret;
    }

    protected boolean isPatternControlled(PictogramElement pictogramElement) {
        ContainerShape patternRoot = this.getPatternRoot(pictogramElement);
        return patternRoot != null;
    }

    protected boolean isPatternRoot(PictogramElement pe) {
        GraphicsAlgorithm ga;
        boolean ret = false;
        if (pe instanceof ContainerShape && pe.eResource() != null && (ga = pe.getGraphicsAlgorithm()) instanceof RoundedRectangle) {
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            ret = this.isMainBusinessObjectApplicable(bo);
        }
        return ret;
    }

    private boolean updateCompartment(Object mainBusinessObject, ContainerShape compartmentContainerShape, IStructureMappingMulti mapping) {
        boolean ret = false;
        List linkCreationInfos = mapping.getLinkCreationInfos(mainBusinessObject);
        EList currentCompartmentElements = compartmentContainerShape.getChildren();
        if (linkCreationInfos.size() != currentCompartmentElements.size()) {
            Object[] a = compartmentContainerShape.getChildren().toArray();
            int i = 0;
            while (i < a.length) {
                Graphiti.getPeService().deletePictogramElement((PictogramElement)a[i]);
                ++i;
            }
            this.createShapesInCompartment(compartmentContainerShape, linkCreationInfos);
            ret = true;
        }
        EList childShapes = compartmentContainerShape.getChildren();
        for (Shape shape : childShapes) {
            ret |= this.updateCompartmentEntry(shape, mapping);
        }
        return ret;
    }

    private boolean updateCompartmentEntry(Shape shape, IStructureMappingMulti mapping) {
        boolean ret = false;
        PictogramLink linkForPictogramElement = this.getLinkService().getLinkForPictogramElement((PictogramElement)shape);
        if (linkForPictogramElement != null) {
            Image imageGa = (Image)shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            Text textGa = (Text)shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(1);
            imageGa.setId(this.getImage((IStructureMapping)mapping, linkForPictogramElement));
            textGa.setValue(this.getText((IStructureMapping)mapping, linkForPictogramElement));
            ret = true;
        }
        return ret;
    }

    private IReason updateCompartmentNeeded(ContainerShape compartmentContainerShape, Object mainBusinessObject, IStructureMappingMulti mapping) {
        List linkCreationInfos = mapping.getLinkCreationInfos(mainBusinessObject);
        EList childShapes = compartmentContainerShape.getChildren();
        int childShapeCount = childShapes.size();
        if (linkCreationInfos.size() != childShapeCount) {
            return Reason.createTrueReason((String)"compartment changes");
        }
        for (Shape shape : childShapes) {
            PictogramLink linkForPictogramElement = this.getLinkService().getLinkForPictogramElement((PictogramElement)shape);
            if (linkForPictogramElement == null) continue;
            Image imageGa = (Image)shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            Text textGa = (Text)shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(1);
            String currentImage = imageGa.getId();
            String currentText = textGa.getValue();
            String image = this.getImage((IStructureMapping)mapping, linkForPictogramElement);
            String text = this.getText((IStructureMapping)mapping, linkForPictogramElement);
            if (currentText == null || !currentText.equals(text)) {
                return Reason.createTrueReason((String)mapping.getDataMapping().getUpdateWarning(linkForPictogramElement));
            }
            if (currentImage == null && image == null || currentImage != null && currentImage.equals(image)) continue;
            return Reason.createTrueReason((String)mapping.getDataMapping().getUpdateWarning(linkForPictogramElement));
        }
        return Reason.createFalseReason();
    }

    private boolean updateHeader(Shape headerShape) {
        boolean ret = false;
        PictogramLink linkForPictogramElement = this.getLinkService().getLinkForPictogramElement((PictogramElement)headerShape);
        if (linkForPictogramElement != null) {
            if (this.getConfiguration().isHeaderImageVisible()) {
                Image imageGa = (Image)headerShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
                Text textGa = (Text)headerShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(1);
                imageGa.setId(this.getImage((IStructureMapping)this.getHeaderMapping(), linkForPictogramElement));
                textGa.setValue(this.getText((IStructureMapping)this.getHeaderMapping(), linkForPictogramElement));
            } else {
                String value = this.getText((IStructureMapping)this.getHeaderMapping(), linkForPictogramElement);
                ((Text)headerShape.getGraphicsAlgorithm()).setValue(value);
            }
            ret = true;
        }
        return ret;
    }

    private boolean updateAndLayoutRoot(ContainerShape outerContainerShape) {
        Object mainBusinessObject = this.getBusinessObjectForPictogramElement((PictogramElement)outerContainerShape);
        Shape textShape = (Shape)outerContainerShape.getChildren().get(0);
        boolean ret = this.updateHeader(textShape);
        int compartmentIndex = 0;
        while (compartmentIndex < this.getCompartmentCount()) {
            ContainerShape compartmentContainerShape = (ContainerShape)outerContainerShape.getChildren().get((compartmentIndex + 1) * 2);
            IStructureMappingMulti mapping = this.getCompartmentMapping(compartmentIndex);
            if (compartmentContainerShape != null) {
                ret |= this.updateCompartment(mainBusinessObject, compartmentContainerShape, mapping);
            }
            ++compartmentIndex;
        }
        this.layoutPictogramElement((PictogramElement)outerContainerShape);
        return ret;
    }

    protected ICompartmentPatternConfiguration getConfiguration() {
        return (ICompartmentPatternConfiguration)this.getPatternConfiguration();
    }

    public void completeInfo(IDirectEditingInfo info, Object bo) {
        super.completeInfo(info, bo);
        PictogramElement mainPictogramElement = info.getMainPictogramElement();
        ContainerShape mainCs = (ContainerShape)mainPictogramElement;
        if (mainCs != null) {
            for (Object childShape : mainCs.getChildren()) {
                if (!(childShape instanceof ContainerShape)) continue;
                ContainerShape compartmentCs = (ContainerShape)childShape;
                for (Object compartmentEntry : compartmentCs.getChildren()) {
                    GraphicsAlgorithm ga;
                    Shape compartmentEntryShape;
                    Object firstBusinessObjectForPictogramElement;
                    if (!(compartmentEntry instanceof Shape) || !bo.equals(firstBusinessObjectForPictogramElement = this.getBusinessObjectForPictogramElement((PictogramElement)(compartmentEntryShape = (Shape)compartmentEntry))) || !((ga = (GraphicsAlgorithm)compartmentEntryShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(1)) instanceof Text)) continue;
                    info.setPictogramElement((PictogramElement)compartmentEntryShape);
                    info.setGraphicsAlgorithm(ga);
                    return;
                }
            }
        }
    }

    protected ILinkService getLinkService() {
        return Graphiti.getLinkService();
    }
}

