/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.examples.common.ExamplesCommonPlugin;
import org.eclipse.graphiti.examples.common.FileService;
import org.eclipse.graphiti.examples.common.navigator.nodes.base.AbstractInstancesOfTypeContainerNode;
import org.eclipse.graphiti.examples.common.ui.DiagramNameWizardPage;
import org.eclipse.graphiti.examples.common.ui.DiagramTypeWizardPage;
import org.eclipse.graphiti.examples.common.ui.ITextProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class CreateDiagramWizard
extends BasicNewResourceWizard {
    private static final String PAGE_NAME_DIAGRAM_TYPE = "Diagram Type";
    private static final String PAGE_NAME_DIAGRAM_NAME = "Diagram Name";
    private static final String WIZARD_WINDOW_TITLE = "New Diagram";
    private Diagram diagram;

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new DiagramTypeWizardPage(PAGE_NAME_DIAGRAM_TYPE));
        this.addPage((IWizardPage)new DiagramNameWizardPage(PAGE_NAME_DIAGRAM_NAME));
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(WIZARD_WINDOW_TITLE);
    }

    public boolean performFinish() {
        ITextProvider typePage = (ITextProvider)this.getPage(PAGE_NAME_DIAGRAM_TYPE);
        String diagramTypeId = typePage.getText();
        ITextProvider namePage = (ITextProvider)this.getPage(PAGE_NAME_DIAGRAM_NAME);
        String diagramName = namePage.getText();
        IProject project = null;
        IFolder diagramFolder = null;
        Object element = this.getSelection().getFirstElement();
        if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof AbstractInstancesOfTypeContainerNode) {
            AbstractInstancesOfTypeContainerNode aiocn = (AbstractInstancesOfTypeContainerNode)element;
            project = aiocn.getProject();
        } else if (element instanceof IFolder) {
            diagramFolder = (IFolder)element;
            project = diagramFolder.getProject();
        }
        if (project == null || !project.isAccessible()) {
            String error = "No open project was found for the current selection. Select a project and restart the wizard.";
            Status status = new Status(4, ExamplesCommonPlugin.getID(), error);
            ErrorDialog.openError((Shell)this.getShell(), (String)"No Project Found", null, (IStatus)status);
            return false;
        }
        Diagram diagram = Graphiti.getPeCreateService().createDiagram(diagramTypeId, diagramName, true);
        if (diagramFolder == null) {
            diagramFolder = project.getFolder("src/diagrams/");
        }
        IFile diagramFile = diagramFolder.getFile(String.valueOf(diagramName) + ".diagram");
        URI uri = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        TransactionalEditingDomain domain = FileService.createEmfFileForDiagram(uri, diagram);
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        DiagramEditorInput editorInput = new DiagramEditorInput(EcoreUtil.getURI((EObject)diagram), domain, providerId);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.eclipse.graphiti.ui.editor.DiagramEditor");
        }
        catch (PartInitException e) {
            String error = "Error while opening diagram editor";
            Status status = new Status(4, ExamplesCommonPlugin.getID(), error, (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)"An error occured", null, (IStatus)status);
            return false;
        }
        return true;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }
}

