/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.ui;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.graphiti.examples.common.ui.AbstractWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DiagramNameWizardPage
extends AbstractWizardPage {
    private static final String PAGE_DESC = "Enter diagram name";
    private static final String PAGE_TITLE = "Diagram";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    Text textField;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = DiagramNameWizardPage.this.validatePage();
            DiagramNameWizardPage.this.setPageComplete(valid);
        }
    };

    public DiagramNameWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected DiagramNameWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createWizardContents(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    @Override
    public String getText() {
        if (this.textField == null) {
            return this.getInitialTextFieldValue();
        }
        return this.getTextFieldValue();
    }

    protected boolean validatePage() {
        String text = this.getTextFieldValue();
        if (text.equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Please enter diagram name");
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = this.doWorkspaceValidation(workspace, text);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    @Override
    protected void createWizardContents(Composite parent) {
        this.createProjectNameGroup(parent);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText("Diagram Name");
        projectLabel.setFont(parent.getFont());
        this.textField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.textField.setLayoutData((Object)data);
        this.textField.setFont(parent.getFont());
        if (this.getInitialTextFieldValue() != null) {
            this.textField.setText(this.getInitialTextFieldValue());
        }
        this.textField.addListener(24, this.nameModifyListener);
    }

    private String getTextFieldValue() {
        if (this.textField == null) {
            return "";
        }
        return this.textField.getText().trim();
    }

    private String getInitialTextFieldValue() {
        return "newDiagram";
    }

    private IStatus doWorkspaceValidation(IWorkspace workspace, String text) {
        IStatus ret = workspace.validateName(text, 1);
        return ret;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.textField.setFocus();
            this.textField.selectAll();
        }
    }
}

