/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.editor.GFWorkspaceCommandStackImpl;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class DiagramEditorFactory
implements IElementFactory {
    public DiagramEditorInput createEditorInput(IEditorInput otherInput) {
        if (otherInput instanceof DiagramEditorInput) {
            return (DiagramEditorInput)otherInput;
        }
        if (otherInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)otherInput;
            IFile file = fileInput.getFile();
            TransactionalEditingDomain domain = DiagramEditorFactory.createResourceSetAndEditingDomain();
            URI diagramFileUri = GraphitiUiInternal.getEmfService().getFileURI(file, domain.getResourceSet());
            if (diagramFileUri != null) {
                diagramFileUri = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(diagramFileUri);
                return new DiagramEditorInput(diagramFileUri, domain, null, true);
            }
        }
        return null;
    }

    public IAdaptable createElement(IMemento memento) {
        String diagramUriString = memento.getString("org.eclipse.graphiti.uri");
        if (diagramUriString == null) {
            return null;
        }
        String providerID = memento.getString(DiagramEditorInput.KEY_PROVIDER_ID);
        TransactionalEditingDomain domain = DiagramEditorFactory.createResourceSetAndEditingDomain();
        return new DiagramEditorInput(diagramUriString, domain, providerID, true);
    }

    public static TransactionalEditingDomain createResourceSetAndEditingDomain() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        GFWorkspaceCommandStackImpl workspaceCommandStack = new GFWorkspaceCommandStackImpl((IOperationHistory)new DefaultOperationHistory());
        TransactionalEditingDomainImpl editingDomain = new TransactionalEditingDomainImpl((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (TransactionalCommandStack)workspaceCommandStack, (ResourceSet)resourceSet);
        WorkspaceEditingDomainFactory.INSTANCE.mapResourceSet((TransactionalEditingDomain)editingDomain);
        return editingDomain;
    }

    public static final class DiagramEditorMatchingStrategy
    implements IEditorMatchingStrategy {
        public boolean matches(IEditorReference editorRef, IEditorInput input) {
            block6: {
                DiagramEditorInput diagInput;
                String uriString;
                URI uri;
                if (!(input instanceof IFileEditorInput)) break block6;
                IFileEditorInput fileInput = (IFileEditorInput)input;
                IFile file = fileInput.getFile();
                IEditorInput editorInput = editorRef.getEditorInput();
                if (editorInput instanceof DiagramEditorInput && (uri = URI.createURI((String)(uriString = (diagInput = (DiagramEditorInput)editorInput).getUriString()))) != null) {
                    URI diagramUri;
                    ResourceSetImpl rSet = new ResourceSetImpl();
                    Diagram diagram = GraphitiUiInternal.getEmfService().getDiagramFromFile(file, (ResourceSet)rSet);
                    if (diagram != null && uri.equals((Object)(diagramUri = EcoreUtil.getURI((EObject)diagram)))) {
                        return true;
                    }
                }
            }
            try {
                IEditorInput editorInput;
                if (input instanceof DiagramEditorInput && input.equals(editorInput = editorRef.getEditorInput())) {
                    return true;
                }
            }
            catch (PartInitException e) {
                T.racer().error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }
}

