/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DefaultDeleteFeature
extends AbstractFeature
implements IDeleteFeature {
    private static final String NAME = Messages.DefaultDeleteFeature_1_xfld;

    public DefaultDeleteFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canDelete(IDeleteContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        RemoveContext rc = new RemoveContext(pictogramElement);
        IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)rc);
        boolean ret = removeFeature != null && removeFeature.canRemove((IRemoveContext)rc);
        return ret;
    }

    public void delete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        if (businessObjectsForPictogramElement != null && businessObjectsForPictogramElement.length > 0 && !this.getUserDecision()) {
            return;
        }
        this.preDelete(context);
        RemoveContext rc = new RemoveContext(pe);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
        if (removeFeature != null) {
            removeFeature.remove((IRemoveContext)rc);
        }
        this.deleteBusinessObjects(businessObjectsForPictogramElement);
        this.postDelete(context);
    }

    protected void deleteBusinessObjects(Object[] businessObjects) {
        if (businessObjects != null) {
            Object[] objectArray = businessObjects;
            int n = businessObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                this.deleteBusinessObject(bo);
                ++n2;
            }
        }
    }

    protected void deleteBusinessObject(Object bo) {
        if (bo instanceof EObject) {
            EcoreUtil.delete((EObject)((EObject)bo), (boolean)true);
        }
    }

    protected boolean getUserDecision() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractFeature_0_xhed, (String)Messages.DefaultDeleteFeature_0_xmsg);
    }

    public void preDelete(IDeleteContext context) {
    }

    public void postDelete(IDeleteContext context) {
    }

    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IDeleteContext) {
            ret = this.canDelete((IDeleteContext)context);
        }
        return ret;
    }

    public void execute(IContext context) {
        if (context instanceof IDeleteContext) {
            this.delete((IDeleteContext)context);
        }
    }

    public String getName() {
        return NAME;
    }
}

