/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.action.IContextAndFeatureProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteAction
extends AbstractPreDefinedAction
implements IContextAndFeatureProvider {
    private static final String TOOL_TIP = Messages.DeleteAction_0_xmsg;
    private static final String TEXT = Messages.DeleteAction_1_xfld;
    public static final String ACTION_ID = "predefined delete action";

    public DeleteAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
    }

    @Override
    public boolean isAvailable() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pe.length) {
            DeleteContext context = new DeleteContext(pe[i]);
            IDeleteFeature deleteFeature = this.getFeatureProvider().getDeleteFeature((IDeleteContext)context);
            if (deleteFeature == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean calculateEnabled() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pe.length) {
            DeleteContext context = new DeleteContext(pe[i]);
            IFeatureProvider featureProvider = this.getFeatureProvider();
            if (featureProvider == null) {
                return false;
            }
            IDeleteFeature deleteFeature = featureProvider.getDeleteFeature((IDeleteContext)context);
            if (deleteFeature != null && !deleteFeature.canDelete((IDeleteContext)context)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        this.genericRun(this);
    }

    @Override
    public IContext createContext(PictogramElement pe) {
        return new DeleteContext(pe);
    }

    @Override
    public IFeature provideFeatureForContext(IContext context) {
        return this.getFeatureProvider().getDeleteFeature((IDeleteContext)context);
    }
}

