/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.action.IContextAndFeatureProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveAction
extends AbstractPreDefinedAction
implements IContextAndFeatureProvider {
    private static final String TOOL_TIP = Messages.RemoveAction_0_xmsg;
    private static final String TEXT = Messages.RemoveAction_1_xfld;
    public static final String ACTION_ID = "predefined remove action";

    public RemoveAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
    }

    @Override
    public boolean isAvailable() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pe.length) {
            RemoveContext context = new RemoveContext(pe[i]);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)context);
            if (removeFeature == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean calculateEnabled() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider == null) {
            return false;
        }
        int i = 0;
        while (i < pe.length) {
            if (GraphitiInternal.getEmfService().isObjectAlive((EObject)pe[i])) {
                RemoveContext context = new RemoveContext(pe[i]);
                IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)context);
                if (removeFeature == null) {
                    return false;
                }
                if (!removeFeature.canRemove((IRemoveContext)context)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void run() {
        this.genericRun(this);
        this.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    public IFeature provideFeatureForContext(IContext context) {
        return this.getFeatureProvider().getRemoveFeature((IRemoveContext)context);
    }

    @Override
    public IContext createContext(PictogramElement pe) {
        return new RemoveContext(pe);
    }
}

