/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.MmPackage;
import org.eclipse.graphiti.mm.algorithms.AlgorithmsPackage;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramsPackage;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.editor.DiagramRefreshJob;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.swt.widgets.Display;

public class DiagramChangeListener
implements ResourceSetListener {
    private DiagramRefreshJob diagramRefreshJob;
    private DiagramEditorInternal ed;

    public DiagramChangeListener(DiagramEditorInternal ed) {
        this.ed = ed;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.NOT_TOUCH;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (!this.ed.isAutoRefresh()) {
            return;
        }
        DiagramRefreshJob refreshDiagramJob = this.getRefreshDiagramJob();
        if (!refreshDiagramJob.isRefreshAll()) {
            GraphicalViewer graphicalViewer = this.ed.getGraphicalViewer();
            if (graphicalViewer == null) {
                return;
            }
            List notifications = event.getNotifications();
            if (notifications.size() > 5000) {
                refreshDiagramJob.setRefreshAll();
            } else {
                for (Notification notification : notifications) {
                    Map editPartRegistry;
                    Object o;
                    PictogramElement activeContainerPe;
                    Object notifier = notification.getNotifier();
                    if (!(notifier instanceof EObject)) continue;
                    EObject eo = (EObject)notifier;
                    if (!GraphitiInternal.getEmfService().isObjectAlive(eo)) continue;
                    if (refreshDiagramJob.isRefreshAll()) break;
                    EPackage p = eo.eClass().getEPackage();
                    if (!(p instanceof PictogramsPackage) && !(p instanceof AlgorithmsPackage) && !(p instanceof StylesPackage) && !(p instanceof MmPackage) || (activeContainerPe = this.calculateActiveContainerPe(eo)) == null || !((o = (editPartRegistry = graphicalViewer.getEditPartRegistry()).get(activeContainerPe)) instanceof EditPart)) continue;
                    EditPart affectedEditPart = (EditPart)o;
                    refreshDiagramJob.addEditPart(affectedEditPart);
                    this.addRelevantChildEditPartsToRefreshJob(activeContainerPe);
                }
            }
        }
        if (refreshDiagramJob.shouldBeRun()) {
            if (Display.getCurrent() != null) {
                refreshDiagramJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
            } else {
                refreshDiagramJob.schedule();
            }
        }
    }

    private void addRelevantChildEditPartsToRefreshJob(PictogramElement pe) {
        Map editPartRegistry = this.ed.getGraphicalViewer().getEditPartRegistry();
        DiagramRefreshJob refreshJob = this.getRefreshDiagramJob();
        if (pe instanceof AnchorContainer) {
            AnchorContainer anchorContainer = (AnchorContainer)pe;
            EList anchors = anchorContainer.getAnchors();
            for (Anchor anchor : anchors) {
                EList incomingConnections = anchor.getIncomingConnections();
                for (Connection connection : incomingConnections) {
                    refreshJob.addEditPart((EditPart)editPartRegistry.get(connection));
                    this.addRelevantChildEditPartsToRefreshJob((PictogramElement)connection);
                }
                EList outgoingConnections = anchor.getOutgoingConnections();
                for (Connection connection : outgoingConnections) {
                    refreshJob.addEditPart((EditPart)editPartRegistry.get(connection));
                    this.addRelevantChildEditPartsToRefreshJob((PictogramElement)connection);
                }
            }
        }
        if (pe instanceof Connection) {
            Connection connection = (Connection)pe;
            for (ConnectionDecorator connectionDecorator : connection.getConnectionDecorators()) {
                if (!connectionDecorator.isActive()) continue;
                Object object = editPartRegistry.get(connectionDecorator);
                if (object instanceof EditPart) {
                    refreshJob.addEditPart((EditPart)object);
                    continue;
                }
                if (object != null) continue;
                refreshJob.setRefreshAll();
                return;
            }
            AnchorContainer end = ((Connection)pe).getEnd() != null ? ((Connection)pe).getEnd().getParent() : null;
            AnchorContainer start = ((Connection)pe).getStart() != null ? ((Connection)pe).getStart().getParent() : null;
            Object endPart = editPartRegistry.get(end);
            Object startPart = editPartRegistry.get(start);
            EditPart connPart = (EditPart)editPartRegistry.get(connection);
            if (connPart instanceof ConnectionEditPart) {
                ConnectionEditPart cep = (ConnectionEditPart)connPart;
                if (cep.getSource() != null && !cep.getSource().equals(startPart)) {
                    refreshJob.addEditPart((EditPart)startPart);
                } else if (cep.getTarget() != null && !cep.getTarget().equals(endPart)) {
                    refreshJob.addEditPart((EditPart)endPart);
                }
            }
        }
    }

    private PictogramElement calculateActiveContainerPe(EObject affectedElement) {
        if (affectedElement instanceof PictogramElement) {
            PictogramElement pe = (PictogramElement)affectedElement;
            if (pe instanceof ChopboxAnchor) {
                pe = ((Anchor)pe).getParent();
            }
            if (pe instanceof Connection) {
                Diagram diagram = ((Connection)pe).getParent();
                return diagram;
            }
            if (pe.isActive()) {
                return pe;
            }
        }
        GraphicsAlgorithmContainer gac = null;
        if (affectedElement instanceof GraphicsAlgorithmContainer) {
            gac = (GraphicsAlgorithmContainer)affectedElement;
        } else {
            boolean cfr_ignored_0 = affectedElement instanceof Point;
        }
        PictogramElement ret = null;
        if (gac != null) {
            if (gac instanceof PictogramElement) {
                ret = (PictogramElement)gac;
            } else if (gac instanceof GraphicsAlgorithm) {
                ret = Graphiti.getPeService().getActiveContainerPe((GraphicsAlgorithm)gac);
            }
        }
        return ret;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    private DiagramRefreshJob getRefreshDiagramJob() {
        if (this.diagramRefreshJob == null) {
            this.diagramRefreshJob = new DiagramRefreshJob(Messages.DiagramEditor_0_xmsg, this.ed);
        }
        return this.diagramRefreshJob;
    }

    boolean stopListening() {
        return this.getRefreshDiagramJob().cancel();
    }
}

