/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.graphiti.ui.internal.fixed.FixedScrollableThumbnail;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ThumbNailView
extends ViewPart
implements IPartListener {
    private FixedScrollableThumbnail _thumbnail;
    private LightweightSystem _lws;
    private IWorkbenchPart _workbenchPart;
    private GraphicalViewer _graphicalViewer;

    public ThumbNailView() {
        IWorkbenchWindow workbenchWindow = GraphitiUiInternal.getWorkbenchService().getActiveOrFirstWorkbenchWindow();
        workbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void createPartControl(Composite parent) {
        Canvas overview = new Canvas(parent, 0);
        this._lws = new LightweightSystem(overview);
        this.refreshThumbnailViewer();
    }

    public void setFocus() {
    }

    public void dispose() {
        IWorkbenchWindow workbenchWindow = GraphitiUiInternal.getWorkbenchService().getActiveOrFirstWorkbenchWindow();
        workbenchWindow.getPartService().removePartListener((IPartListener)this);
        super.dispose();
        this.clearThumbnail();
    }

    public void partActivated(IWorkbenchPart part) {
        GraphicalViewer viewer;
        if (!part.equals(this._workbenchPart) && (viewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class)) != null) {
            this.createThumbNailViewer(part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this._workbenchPart)) {
            this.refreshThumbnailViewer();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    private void clearThumbnail() {
        if (this._thumbnail != null) {
            this._thumbnail.deactivate();
            this._thumbnail = null;
        }
    }

    public void partOpened(IWorkbenchPart part) {
        GraphicalViewer viewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            this.createThumbNailViewer(part);
        }
    }

    private void refreshThumbnailViewer() {
        IWorkbenchPart part = this.findGraphicalViewerAdaptable();
        this.createThumbNailViewer(part);
    }

    private IWorkbenchPart findGraphicalViewerAdaptable() {
        IWorkbenchWindow window = GraphitiUiInternal.getWorkbenchService().getActiveOrFirstWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart == null) {
            return null;
        }
        GraphicalViewer currentViewer = (GraphicalViewer)activePart.getAdapter(GraphicalViewer.class);
        if (currentViewer != null) {
            return activePart;
        }
        return null;
    }

    private void createThumbNailViewer(IWorkbenchPart part) {
        if (part != null) {
            this._graphicalViewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
            this._workbenchPart = part;
            if (this._graphicalViewer != null) {
                SimpleRootEditPart rootEditPart = (SimpleRootEditPart)this._graphicalViewer.getRootEditPart();
                this._thumbnail = new FixedScrollableThumbnail((Viewport)rootEditPart.getFigure());
                this._thumbnail.setBorder((Border)new MarginBorder(3));
                if (rootEditPart instanceof LayerManager) {
                    this._thumbnail.setSource(((LayerManager)rootEditPart).getLayer((Object)"Printable Layers"));
                }
                this._lws.setContents((IFigure)this._thumbnail);
            }
        } else {
            this._graphicalViewer = null;
            this._workbenchPart = null;
            this._lws.setContents((IFigure)new Figure());
        }
    }
}

