/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.fixed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.swt.graphics.Path;

public class FixedScaledGraphics
extends ScaledGraphics {
    private Graphics graphics;
    private static Method clipMethod = null;

    static {
        try {
            clipMethod = Graphics.class.getMethod("clipPath", Path.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public FixedScaledGraphics(Graphics graphics) {
        super(graphics);
        this.graphics = graphics;
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.graphics.fillGradient(x, y, w, h, vertical);
    }

    public void rotate(float degrees) {
        this.graphics.rotate(degrees);
    }

    public void translate(float dx, float dy) {
        this.graphics.translate(Math.round(dx), Math.round(dy));
    }

    public void drawPath(Path path) {
        this.graphics.drawPath(path);
    }

    public void fillPath(Path path) {
        this.graphics.fillPath(path);
    }

    public void clipPath(Path path) {
        if (clipMethod != null) {
            try {
                clipMethod.invoke((Object)this.graphics, path);
            }
            catch (IllegalArgumentException e) {
                this.fallBack(path);
            }
            catch (IllegalAccessException e) {
                this.fallBack(path);
            }
            catch (InvocationTargetException e) {
                this.fallBack(path);
            }
        } else {
            this.setClip(path);
        }
    }

    private void fallBack(Path path) {
        clipMethod = null;
        this.setClip(path);
    }

    public void setClip(Path path) {
        this.graphics.setClip(path);
    }
}

