/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.internal.command.DirectEditingFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.util.LookManager;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.parts.directedit.IDirectEditHolder;
import org.eclipse.graphiti.ui.internal.requests.GFDirectEditRequest;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DefaultDirectEditPolicy
extends DirectEditPolicy {
    private final IConfigurationProvider configurationProvider;

    public DefaultDirectEditPolicy(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Command getDirectEditCommand(DirectEditRequest request) {
        if (!(request instanceof GFDirectEditRequest)) {
            return null;
        }
        String message = request.getCellEditor().getErrorMessage();
        if (message != null && message.length() != 0) {
            MessageDialog.openError((Shell)GraphitiUiInternal.getWorkbenchService().getShell(), (String)Messages.DefaultDirectEditPolicy_0_xmsg, (String)message);
            return null;
        }
        IDirectEditHolder directEditHolder = ((GFDirectEditRequest)request).getDirectEditHolder();
        IDirectEditingFeature directEditingFeature = directEditHolder.getDirectEditingFeature();
        IDirectEditingContext directEditingContext = directEditHolder.getDirectEditingContext();
        Object valueObject = request.getCellEditor().getValue();
        if (directEditingFeature.getEditingType() == 3 || directEditingFeature.getEditingType() == 6) {
            int index = (Integer)valueObject;
            if (index < 0) {
                Control control = request.getCellEditor().getControl();
                if (!(control instanceof CCombo)) return null;
                CCombo cc = (CCombo)control;
                valueObject = cc.getText();
            } else {
                valueObject = directEditingFeature.getPossibleValues(directEditingContext)[index];
            }
        }
        DirectEditingFeatureCommandWithContext cmd = new DirectEditingFeatureCommandWithContext(directEditingFeature, directEditingContext, (String)valueObject);
        IFeatureProvider fp = directEditingFeature.getFeatureProvider();
        DiagramEditorInternal diagramEditor = (DiagramEditorInternal)fp.getDiagramTypeProvider().getDiagramEditor();
        CommandStack commandStack = diagramEditor.getEditDomain().getCommandStack();
        commandStack.execute((Command)new GefCommandWrapper((ICommand)cmd, diagramEditor.getEditingDomain()));
        return null;
    }

    protected void showCurrentEditValue(DirectEditRequest request) {
        Object currentValue = request.getCellEditor().getValue();
        this.getHostFigure().getUpdateManager().performUpdate();
    }

    protected void showDirectEditFeedback(DirectEditRequest request) {
        super.showDirectEditFeedback(request);
        String errorMessage = request.getCellEditor().getErrorMessage();
        Control control = request.getCellEditor().getControl();
        if (errorMessage == null) {
            control.setBackground(ColorConstants.listBackground);
        } else {
            IColorConstant cc = LookManager.getLook().getFieldErrorBackgroundColor();
            int r = cc.getRed();
            int g = cc.getGreen();
            int b = cc.getBlue();
            Color errorColor = DataTypeTransformation.toSwtColor(this.configurationProvider, r, g, b);
            control.setBackground(errorColor);
        }
        GraphitiUiInternal.getWorkbenchService().getActiveStatusLineManager().setErrorMessage(errorMessage);
    }
}

