/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.command.ReconnectCommand;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.requests.ContextButtonDragRequest;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFColorConstants;

public class GFNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private IConfigurationProvider configurationProvider;
    Rectangle rec;

    private void identifySourceFigure(Request req) {
        if (req instanceof CreateConnectionRequest) {
            CreateConnectionRequest r = (CreateConnectionRequest)req;
            if (r.getSourceEditPart() instanceof AbstractGraphicalEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)r.getSourceEditPart();
                this.rec = ep.getFigure().getBounds();
            }
        } else {
            this.rec = null;
        }
    }

    protected org.eclipse.draw2d.Connection createDummyConnection(Request req) {
        this.identifySourceFigure(req);
        PolylineConnection c = new PolylineConnection(){

            public void paint(Graphics g) {
                if (GFNodeEditPolicy.this.rec != null && GFNodeEditPolicy.this.rec.contains(this.getPoints().getLastPoint())) {
                    return;
                }
                g.setAntialias(1);
                super.paint(g);
            }
        };
        c.setLineWidth((int)(2.0 * this.configurationProvider.getDiagramEditor().getZoomLevel()));
        c.setForegroundColor(GFColorConstants.HANDLE_BG);
        c.setLineStyle(2);
        return c;
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateConnectionRequest) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
        }
    }

    public GFNodeEditPolicy(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (request instanceof ContextButtonDragRequest) {
            ContextButtonDragRequest cbdr = (ContextButtonDragRequest)request;
            CreateConnectionCommand cmd = new CreateConnectionCommand(this.configurationProvider, (PictogramElement)this.getHost().getModel(), cbdr.getContextButtonEntry().getDragAndDropFeatures());
            request.setStartCommand((Command)cmd);
            cmd.setLocation(request.getLocation());
            return cmd;
        }
        if (this.getHost().getModel() instanceof PictogramElement && request.getNewObject() instanceof List) {
            Object newObject = request.getNewObject();
            List features = (List)newObject;
            CreateConnectionCommand cmd = new CreateConnectionCommand(this.configurationProvider, (PictogramElement)this.getHost().getModel(), features);
            if (!cmd.canStartConnection()) {
                return null;
            }
            cmd.setLocation(request.getLocation());
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        return null;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (request.getStartCommand() instanceof CreateConnectionCommand) {
            CreateConnectionCommand cmd = (CreateConnectionCommand)request.getStartCommand();
            Object target = request.getTargetEditPart().getModel();
            if (target instanceof PictogramElement) {
                cmd.setTarget((PictogramElement)target);
            }
            cmd.setLocation(request.getLocation());
            if (cmd.canExecute()) {
                return cmd;
            }
        }
        return null;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Connection conn = (Connection)request.getConnectionEditPart().getModel();
        return this.getReconnectCommand(conn, conn.getEnd(), ReconnectionContext.RECONNECT_TARGET);
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Connection conn = (Connection)request.getConnectionEditPart().getModel();
        return this.getReconnectCommand(conn, conn.getStart(), ReconnectionContext.RECONNECT_SOURCE);
    }

    private ReconnectCommand getReconnectCommand(Connection conn, Anchor oldAnchor, String reconnectType) {
        PictogramElement newTarget = (PictogramElement)this.getHost().getModel();
        Anchor newAnchor = this.getAnchorForPictogramElement(newTarget);
        ReconnectCommand cmd = new ReconnectCommand(this.getConfigurationProvider(), conn, oldAnchor, newAnchor, newTarget, reconnectType);
        return cmd;
    }

    private Anchor getAnchorForPictogramElement(PictogramElement connectionTarget) {
        if (connectionTarget instanceof Anchor) {
            return (Anchor)connectionTarget;
        }
        if (connectionTarget instanceof AnchorContainer) {
            EList existingAnchors = ((AnchorContainer)connectionTarget).getAnchors();
            for (Anchor anchor : existingAnchors) {
                if (!(anchor instanceof ChopboxAnchor)) continue;
                return anchor;
            }
        }
        return null;
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }
}

