/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.graphiti.ui.internal.util.ui.DefaultPreferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DoubleField
extends Composite
implements ModifyListener {
    public static final String decimalNumberFormat = "###0.00";
    public static final DecimalFormat decimalNumberFormatter = new DecimalFormat("###0.00");
    private DefaultPreferences _preferences;
    private int _index;
    Text _text;
    private boolean _internalModify = false;
    private boolean _initialUpdate = true;

    public DoubleField(Composite parent, int style, DefaultPreferences prefs, int index) {
        super(parent, style);
        this._preferences = prefs;
        this._index = index;
        FillLayout fill = new FillLayout();
        this.setLayout((Layout)fill);
        this._text = new Text((Composite)this, 2052);
        this.updateControl();
        this._text.addModifyListener((ModifyListener)this);
        this._text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DoubleField.this._text.selectAll();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        GridData gridData = new GridData(32);
        gridData.widthHint = 50;
    }

    public void setEnabled(boolean en) {
        this._text.setEnabled(en);
    }

    public void updateControl() {
        block9: {
            this._internalModify = true;
            double newValue = this._preferences.getDoublePreference(this._index);
            try {
                try {
                    if (this._text.getText().length() != 0) {
                        double oldValue = Double.valueOf(this._text.getText());
                        if (newValue != oldValue) {
                            this._text.setText(decimalNumberFormatter.format(newValue));
                        }
                    } else if (this._initialUpdate) {
                        this._text.setText(decimalNumberFormatter.format(newValue));
                    }
                }
                catch (NumberFormatException e) {
                    this._text.setText(decimalNumberFormatter.format(newValue));
                    this._internalModify = false;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this._internalModify = false;
                throw throwable;
            }
            this._internalModify = false;
        }
        this._initialUpdate = false;
    }

    public Text getText() {
        return this._text;
    }

    public void addModifyListener(ModifyListener listener) {
        this._text.addModifyListener(listener);
    }

    public void modifyText(ModifyEvent e) {
        if (this._internalModify) {
            return;
        }
        try {
            String text = this._text.getText();
            double value = text.length() == 0 ? decimalNumberFormatter.parse("0").doubleValue() : decimalNumberFormatter.parse(text).doubleValue();
            this._preferences.setDoublePreference(this._index, value);
        }
        catch (ParseException x) {
            this.updateControl();
        }
    }
}

