/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui.print;

import java.util.Locale;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.util.ui.DoubleFieldWithDropDown;
import org.eclipse.graphiti.ui.internal.util.ui.print.AbstractFigureSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SaveFigureAsImageDialog
extends AbstractFigureSelectionDialog
implements ModifyListener {
    public static final String[] IMAGE_FILE_EXTENSIONS = new String[]{"BMP", "GIF", "JPG", "RLE"};
    public static final int[] IMAGE_FILE_TYPES;
    public static final String[] WIDTHS;
    public static final String[] HEIGHTS;
    public static final double[] SCALE_FACTORS;
    private Combo _formatCombo;
    private Combo _widthCombo;
    private Combo _heightCombo;
    private DoubleFieldWithDropDown _scaleFactorText;
    private int _formatIndex = 0;

    static {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 1;
        IMAGE_FILE_TYPES = nArray;
        WIDTHS = new String[]{"320", "640", "800", "1024", "1280", "1600"};
        HEIGHTS = new String[]{"200", "400", "600", "768", "1024", "1280"};
        SCALE_FACTORS = new double[]{0.5, 1.0, 2.0, 4.0};
    }

    public SaveFigureAsImageDialog(Shell shell, GraphicalViewer graphicalViewer) {
        super(shell, graphicalViewer);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createChooseFigureGroup(composite);
        Group scaleGroup = this.createChooseScaleFactorGroup(composite);
        Label widthComboText = new Label((Composite)scaleGroup, 0);
        widthComboText.setText(Messages.SaveFigureAsImageDialog_0_xfld);
        this._widthCombo = new Combo((Composite)scaleGroup, 4);
        this._widthCombo.setItems(WIDTHS);
        this._widthCombo.addModifyListener((ModifyListener)this);
        GridData data = new GridData(768);
        this._widthCombo.setLayoutData((Object)data);
        Label heightComboText = new Label((Composite)scaleGroup, 0);
        heightComboText.setText(Messages.SaveFigureAsImageDialog_1_xfld);
        this._heightCombo = new Combo((Composite)scaleGroup, 4);
        this._heightCombo.setItems(HEIGHTS);
        this._heightCombo.addModifyListener((ModifyListener)this);
        GridData data2 = new GridData(768);
        this._heightCombo.setLayoutData((Object)data2);
        this.createFormatGroup(composite);
        this.updateControls();
        return composite;
    }

    private void createFormatGroup(Composite composite) {
        Group formatGroup = new Group(composite, 0);
        formatGroup.setLayout((Layout)new GridLayout(2, false));
        Label formatComboText = new Label((Composite)formatGroup, 0);
        formatComboText.setText(Messages.SaveFigureAsImageDialog_2_xfld);
        GridData data4 = new GridData(128);
        formatComboText.setLayoutData((Object)data4);
        this._formatCombo = new Combo((Composite)formatGroup, 12);
        this._formatCombo.setItems(IMAGE_FILE_EXTENSIONS);
        this._formatCombo.setText(IMAGE_FILE_EXTENSIONS[this._formatIndex]);
        this._formatCombo.addModifyListener((ModifyListener)this);
        GridData data3 = new GridData(768);
        this._formatCombo.setLayoutData((Object)data3);
    }

    private Group createChooseScaleFactorGroup(Composite composite) {
        Group scaleGroup = new Group(composite, 0);
        scaleGroup.setText(Messages.SaveFigureAsImageDialog_3_xfld);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        data.verticalSpan = 2;
        scaleGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        scaleGroup.setLayout((Layout)layout);
        Label scaleFactorText = new Label((Composite)scaleGroup, 0);
        scaleFactorText.setText(Messages.SaveFigureAsImageDialog_4_xfld);
        this._scaleFactorText = new DoubleFieldWithDropDown((Composite)scaleGroup, 0, this._preferences, 4, SCALE_FACTORS);
        data = new GridData(768);
        this._scaleFactorText.setLayoutData(data);
        this._scaleFactorText.addModifyListener(this);
        return scaleGroup;
    }

    public void modifyText(ModifyEvent e) {
        if (this._insideInternalModify) {
            return;
        }
        if (e.getSource() == this._formatCombo) {
            this._formatIndex = this._formatCombo.getSelectionIndex();
        } else if (e.getSource() == this._widthCombo) {
            try {
                String text = this._widthCombo.getText();
                if (text.length() == 0) {
                    text = "0";
                }
                int width = Integer.parseInt(text);
                this._preferences.setDoublePreference(4, (double)width / (double)this._figure.getBounds().width);
            }
            catch (NumberFormatException x) {
                T.racer().error("illegal number format", (Throwable)x);
            }
            this.updateControls();
        } else if (e.getSource() == this._heightCombo) {
            try {
                String text = this._heightCombo.getText();
                if (text.length() == 0) {
                    text = "0";
                }
                int height = Integer.parseInt(text);
                this._preferences.setDoublePreference(4, (double)height / (double)this._figure.getBounds().height);
            }
            catch (NumberFormatException x) {
                T.racer().error("illegal number format", (Throwable)x);
            }
            this.updateControls();
        } else {
            this.updateControls();
        }
    }

    @Override
    public void updateControls() {
        super.updateControls();
        this._insideInternalModify = true;
        try {
            double scaleFactor = this._preferences.getDoublePreference(4);
            String newText = Long.toString(Math.round(scaleFactor * (double)this._figure.getBounds().width));
            if (!newText.equals(this._widthCombo.getText())) {
                this._widthCombo.setText(newText);
            }
            if (!(newText = Long.toString(Math.round(scaleFactor * (double)this._figure.getBounds().height))).equals(this._heightCombo.getText())) {
                this._heightCombo.setText(newText);
            }
            this._scaleFactorText.updateControl();
        }
        finally {
            this._insideInternalModify = false;
        }
    }

    protected void okPressed() {
        this.setScaledImage(this.getImageScaleFactor());
        super.okPressed();
    }

    public final int getImageFormat() {
        return IMAGE_FILE_TYPES[this._formatIndex];
    }

    public final String getFileExtensionForImageFormat() {
        return IMAGE_FILE_EXTENSIONS[this._formatIndex].toLowerCase(Locale.ENGLISH);
    }

    public double getImageScaleFactor() {
        return this._preferences.getDoublePreference(4);
    }
}

