/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.impl.AbstractMoveShapeFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultMoveShapeFeature
extends AbstractMoveShapeFeature {
    public DefaultMoveShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected boolean avoidNegativeCoordinates() {
        return false;
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        return context.getSourceContainer() != null && context.getSourceContainer().equals(context.getTargetContainer());
    }

    @Override
    public final void moveShape(IMoveShapeContext context) {
        this.preMoveShape(context);
        this.moveAllBendpoints(context);
        this.internalMove(context);
        this.postMoveShape(context);
    }

    protected void postMoveShape(IMoveShapeContext context) {
    }

    protected void preMoveShape(IMoveShapeContext context) {
    }

    protected void internalMove(IMoveShapeContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        Shape shapeToMove = context.getShape();
        ContainerShape oldContainerShape = context.getSourceContainer();
        ContainerShape newContainerShape = context.getTargetContainer();
        int x = context.getX();
        int y = context.getY();
        if (oldContainerShape != newContainerShape) {
            EList children;
            PictogramElement[] currentSelection = this.getDiagramEditor().getSelectedPictogramElements();
            if (oldContainerShape != null && (children = oldContainerShape.getChildren()) != null) {
                children.remove(shapeToMove);
            }
            shapeToMove.setContainer(newContainerShape);
            if (shapeToMove.getGraphicsAlgorithm() != null) {
                Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
            }
            this.getDiagramEditor().setPictogramElementsForSelection(currentSelection);
        } else if (shapeToMove.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
        }
    }

    protected void moveAllBendpoints(IMoveShapeContext context) {
        if (!(context.getShape() instanceof ContainerShape)) {
            return;
        }
        ContainerShape shapeToMove = (ContainerShape)context.getShape();
        int x = context.getX();
        int y = context.getY();
        int deltaX = x - shapeToMove.getGraphicsAlgorithm().getX();
        int deltaY = y - shapeToMove.getGraphicsAlgorithm().getY();
        if (deltaX != 0 || deltaY != 0) {
            List<Anchor> anchorsFrom = this.getAnchors(shapeToMove);
            ArrayList<Anchor> anchorsTo = new ArrayList<Anchor>(anchorsFrom);
            for (Anchor anchorFrom : anchorsFrom) {
                EList outgoingConnections = anchorFrom.getOutgoingConnections();
                for (Connection connection : outgoingConnections) {
                    for (Anchor anchorTo : anchorsTo) {
                        EList incomingConnections = anchorTo.getIncomingConnections();
                        if (!incomingConnections.contains(connection) || !(connection instanceof FreeFormConnection)) continue;
                        FreeFormConnection ffc = (FreeFormConnection)connection;
                        EList points = ffc.getBendpoints();
                        int i = 0;
                        while (i < points.size()) {
                            Point point = (Point)points.get(i);
                            int oldX = point.getX();
                            int oldY = point.getY();
                            points.set(i, Graphiti.getGaCreateService().createPoint(oldX + deltaX, oldY + deltaY));
                            ++i;
                        }
                    }
                }
            }
        }
    }

    private List<Anchor> getAnchors(ContainerShape containerShape) {
        ArrayList<Anchor> ret = new ArrayList<Anchor>();
        ret.addAll((Collection<Anchor>)containerShape.getAnchors());
        EList children = containerShape.getChildren();
        for (Shape shape : children) {
            if (shape instanceof ContainerShape) {
                ret.addAll(this.getAnchors((ContainerShape)shape));
                continue;
            }
            ret.addAll((Collection<Anchor>)shape.getAnchors());
        }
        return ret;
    }
}

