/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.graphiti.features.DefaultResizeConfiguration;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeConfiguration;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultResizeShapeFeature
extends AbstractFeature
implements IResizeShapeFeature {
    private static final String NAME = Messages.DefaultResizeShapeFeature_0_xfld;

    public DefaultResizeShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canResizeShape(IResizeShapeContext context) {
        return true;
    }

    @Override
    public void resizeShape(IResizeShapeContext context) {
        Shape shape = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int width = context.getWidth();
        int height = context.getHeight();
        if (shape.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocationAndSize(shape.getGraphicsAlgorithm(), x, y, width, height);
        }
        this.layoutPictogramElement((PictogramElement)shape);
    }

    @Override
    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IResizeShapeContext) {
            ret = this.canResizeShape((IResizeShapeContext)context);
        }
        return ret;
    }

    @Override
    public void execute(IContext context) {
        if (context instanceof IResizeShapeContext) {
            this.resizeShape((IResizeShapeContext)context);
        }
    }

    protected void resizeShape(Shape currentShape) {
        ResizeShapeContext resizeShapeContext = new ResizeShapeContext(currentShape);
        IResizeShapeFeature resizeShapeFeature = this.getFeatureProvider().getResizeShapeFeature(resizeShapeContext);
        if (resizeShapeFeature != null && resizeShapeFeature.canResizeShape(resizeShapeContext)) {
            resizeShapeFeature.resizeShape(resizeShapeContext);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public IResizeConfiguration getResizeConfiguration() {
        return new DefaultResizeConfiguration();
    }
}

