/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.services.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.internal.ExternalPictogramLink;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public final class LinkServiceImpl
implements ILinkService {
    private long cumulativeTime = 0L;
    private int cumulativeCalls = 0;
    private static final String KEY_LINK_PROPERTY = "keyLinkProperty";

    @Override
    public EObject[] getAllBusinessObjectsForLinkedPictogramElement(PictogramElement pictogramElement) {
        EList boList;
        PictogramLink pl;
        EObject[] ret = new EObject[]{};
        if (pictogramElement != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)pictogramElement) && (pl = this.getLinkForPictogramElement(pictogramElement)) != null && !(pl instanceof ExternalPictogramLink) && GraphitiInternal.getEmfService().isObjectAlive((EObject)pl) && (boList = pl.getBusinessObjects()) != null && boList.size() > 0) {
            ret = boList.toArray(new EObject[boList.size()]);
        }
        return ret;
    }

    @Override
    public EObject getBusinessObjectForLinkedPictogramElement(PictogramElement pictogramElement) {
        EObject ret = null;
        EObject[] eObject = this.getAllBusinessObjectsForLinkedPictogramElement(pictogramElement);
        if (eObject != null && eObject.length > 0) {
            ret = eObject[0];
        }
        return ret;
    }

    @Override
    public PictogramLink getLinkForPictogramElement(PictogramElement pictogramElement) {
        Property independentProperty;
        long start = System.currentTimeMillis();
        PictogramLink ret = null;
        if (pictogramElement != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)pictogramElement)) {
            ret = pictogramElement.getLink();
        }
        if (T.racer().info()) {
            long end = System.currentTimeMillis();
            long time = end - start;
            this.cumulativeTime += time;
            ++this.cumulativeCalls;
            double averageTime = (double)this.cumulativeTime / (double)this.cumulativeCalls;
            String averageTimeString = new DecimalFormat("0.000").format(averageTime);
            T.racer().info("LinkUtil.getLinkForPictogramElement() took " + time + " ms (cumulative: " + this.cumulativeTime + " ms for " + this.cumulativeCalls + " calls; average: " + averageTimeString + " ms/call)");
            T.racer().info("LinkUtil.getLinkForPictogramElement() average time: " + averageTimeString + " ms/call)");
        }
        if (ret == null && (independentProperty = Graphiti.getPeService().getProperty((PropertyContainer)pictogramElement, "independentObject")) != null) {
            ret = new ExternalPictogramLink();
            ret.setPictogramElement(pictogramElement);
        }
        return ret;
    }

    @Override
    public List<PictogramElement> getPictogramElements(Diagram diagram, EObject eObject) {
        ArrayList<PictogramElement> ret = new ArrayList<PictogramElement>();
        if (eObject != null && GraphitiInternal.getEmfService().isObjectAlive(eObject)) {
            EList links = diagram.getPictogramLinks();
            block0: for (PictogramLink link : links) {
                EObject[] bos;
                EObject[] eObjectArray = bos = this.getAllBusinessObjectsForLinkedPictogramElement(link.getPictogramElement());
                int n = bos.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject bo = eObjectArray[n2];
                    if (EcoreUtil.equals((EObject)eObject, (EObject)bo)) {
                        ret.add(link.getPictogramElement());
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return ret;
    }

    @Override
    public List<PictogramElement> getPictogramElements(Diagram diagram, List<EObject> eObjects, boolean onlyActive) {
        ArrayList<PictogramElement> ret = new ArrayList<PictogramElement>();
        if (diagram != null && eObjects != null && eObjects.size() > 0) {
            EList links = diagram.getPictogramLinks();
            block0: for (PictogramLink link : links) {
                EObject[] bos;
                PictogramElement pe = link.getPictogramElement();
                if (onlyActive && !pe.isActive()) continue;
                EObject[] eObjectArray = bos = this.getAllBusinessObjectsForLinkedPictogramElement(pe);
                int n = bos.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject bo = eObjectArray[n2];
                    if (eObjects.contains(bo)) {
                        ret.add(pe);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean hasLinkProperty(PictogramElement pictogramElement, String propertyValue) {
        Property property;
        boolean ret = false;
        if (pictogramElement != null && propertyValue != null && (property = this.getLinkProperty(pictogramElement)) != null && propertyValue.equals(property.getValue())) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void setLinkProperty(PictogramElement pictogramElement, String propertyValue) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)pictogramElement, KEY_LINK_PROPERTY, propertyValue);
    }

    @Override
    public Property getLinkProperty(PictogramElement pictogramElement) {
        return Graphiti.getPeService().getProperty((PropertyContainer)pictogramElement, KEY_LINK_PROPERTY);
    }
}

