/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.pattern.grid;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.examples.common.pattern.grid.DefaultGridPatternConfiguration;
import org.eclipse.graphiti.examples.common.pattern.grid.IGridPatternConfiguration;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.AbstractPattern;
import org.eclipse.graphiti.pattern.config.IPatternConfiguration;
import org.eclipse.graphiti.pattern.mapping.ILinkCreationInfo;
import org.eclipse.graphiti.pattern.mapping.IStructureMapping;
import org.eclipse.graphiti.pattern.mapping.IStructureMappingGrid;
import org.eclipse.graphiti.pattern.mapping.IStructureMappingMulti;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridPattern
extends AbstractPattern {
    private IStructureMappingGrid gridMapping;

    public GridPattern() {
        super((IPatternConfiguration)new DefaultGridPatternConfiguration());
    }

    public final PictogramElement add(IAddContext context) {
        Object mainBusinessObject = context.getNewObject();
        ContainerShape parentContainerShape = context.getTargetContainer();
        ContainerShape containerShape = Graphiti.getPeCreateService().createContainerShape(parentContainerShape, true);
        int minWidth = this.getConfiguration().getMinimumWidth();
        int minHeight = this.getConfiguration().getMinimumHeight();
        int width = context.getWidth() <= minWidth ? minWidth : context.getWidth();
        int height = context.getHeight() <= minHeight ? minHeight : context.getHeight();
        IGaService gaService = Graphiti.getGaService();
        Rectangle rectangle = gaService.createRectangle((GraphicsAlgorithmContainer)containerShape);
        rectangle.setForeground(this.manageColor(this.getConfiguration().getForegroundColor()));
        rectangle.setBackground(this.manageColor(this.getConfiguration().getBackgroundColor()));
        rectangle.setLineWidth(Integer.valueOf(this.getConfiguration().getLineWidth() * 2));
        rectangle.setTransparency(Double.valueOf(this.getConfiguration().getTransparency()));
        gaService.setLocationAndSize((GraphicsAlgorithm)rectangle, context.getX(), context.getY(), width, height);
        this.link((PictogramElement)containerShape, mainBusinessObject);
        this.createSeparators((GraphicsAlgorithm)rectangle, this.getColumnCount() - 1, this.getConfiguration().getMajorUnitX());
        this.createSeparators((GraphicsAlgorithm)rectangle, this.getRowCount() - 1, this.getConfiguration().getMajorUnitY());
        this.updatePictogramElement((PictogramElement)containerShape);
        return containerShape;
    }

    private void createSeparators(GraphicsAlgorithm parentGraphicsAlgorithm, int separators, int majorUnit) {
        int i = 1;
        while (i <= separators) {
            Polyline polyline = Graphiti.getGaCreateService().createPolyline((GraphicsAlgorithmContainer)parentGraphicsAlgorithm, new int[4]);
            polyline.setForeground(this.manageColor(this.getConfiguration().getForegroundColor()));
            int lineWidth = majorUnit > 0 && i % majorUnit == 0 ? this.getConfiguration().getMajorUnitSeparatorWidth() : this.getConfiguration().getMinorSeparatorWidth();
            polyline.setLineWidth(Integer.valueOf(lineWidth));
            ++i;
        }
    }

    public boolean layout(ILayoutContext context) {
        boolean ret = true;
        IGaService gaService = Graphiti.getGaService();
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        int cellWidth = containerShape.getGraphicsAlgorithm().getWidth() / this.getColumnCount();
        int cellHeight = containerShape.getGraphicsAlgorithm().getHeight() / this.getRowCount();
        EList children = containerShape.getChildren();
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                int cellIndex = y * this.getColumnCount() + x;
                PictogramElement cellShape = (PictogramElement)children.get(cellIndex);
                int xPos = x * cellWidth;
                int yPos = y * cellHeight;
                gaService.setLocationAndSize(cellShape.getGraphicsAlgorithm(), xPos, yPos, cellWidth, cellHeight);
                ++y;
            }
            ++x;
        }
        EList polylines = containerShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren();
        int xSep = this.getColumnCount() - 1;
        int currentX = cellWidth;
        int i = 0;
        while (i < xSep) {
            EList points = ((Polyline)polylines.get(i)).getPoints();
            points.set(0, gaService.createPoint(currentX, 0));
            points.set(1, gaService.createPoint(currentX, containerShape.getGraphicsAlgorithm().getHeight()));
            currentX += cellWidth;
            ++i;
        }
        int currentY = cellHeight;
        int i2 = xSep;
        while (i2 < polylines.size()) {
            EList points = ((Polyline)polylines.get(i2)).getPoints();
            points.set(0, gaService.createPoint(0, currentY));
            points.set(1, gaService.createPoint(containerShape.getGraphicsAlgorithm().getWidth(), currentY));
            currentY += cellHeight;
            ++i2;
        }
        return ret;
    }

    public boolean update(IUpdateContext context) {
        boolean ret = false;
        PictogramElement pe = context.getPictogramElement();
        if (this.isPatternRoot(pe)) {
            ret = this.updateRoot((ContainerShape)pe);
        } else {
            ContainerShape rootContainer = this.getPatternRoot(pe);
            if (rootContainer != null) {
                ret = this.updateRoot(rootContainer);
            }
        }
        return ret;
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (this.isPatternRoot(pe)) {
            ContainerShape containerShape = (ContainerShape)pe;
            EList shapes = containerShape.getChildren();
            int cells = this.getRowCount() * this.getColumnCount();
            if (cells != shapes.size()) {
                return Reason.createTrueReason();
            }
            for (Shape shape : shapes) {
                IReason ret = this.updateCellNeeded(shape, (IStructureMappingMulti)this.getGridMapping());
                if (!ret.toBoolean()) continue;
                return ret;
            }
        }
        return Reason.createFalseReason();
    }

    protected abstract IStructureMappingGrid createGridMapping();

    private IStructureMappingGrid getGridMapping() {
        if (this.gridMapping == null) {
            this.gridMapping = this.createGridMapping();
        }
        return this.gridMapping;
    }

    private ContainerShape getPatternRoot(PictogramElement pe) {
        ContainerShape ret = null;
        if (pe != null && pe.eResource() != null) {
            int i = 0;
            do {
                if (this.isPatternRoot(pe)) {
                    ret = (ContainerShape)pe;
                    continue;
                }
                if (!(pe instanceof Shape)) continue;
                pe = ((Shape)pe).getContainer();
            } while (ret == null && ++i < 2);
        }
        return ret;
    }

    protected boolean isPatternControlled(PictogramElement pictogramElement) {
        ContainerShape patternRoot = this.getPatternRoot(pictogramElement);
        return patternRoot != null;
    }

    protected boolean isPatternRoot(PictogramElement pe) {
        GraphicsAlgorithm ga;
        boolean ret = false;
        if (pe instanceof ContainerShape && pe.eResource() != null && (ga = pe.getGraphicsAlgorithm()) instanceof Rectangle) {
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            ret = this.isMainBusinessObjectApplicable(bo);
        }
        return ret;
    }

    private IReason updateCellNeeded(Shape shape, IStructureMappingMulti mapping) {
        IReason ret = Reason.createFalseReason();
        PictogramLink linkForPictogramElement = Graphiti.getLinkService().getLinkForPictogramElement((PictogramElement)shape);
        if (linkForPictogramElement != null) {
            boolean booleanRet;
            Text textGa = (Text)shape.getGraphicsAlgorithm();
            boolean bl = booleanRet = !this.getText((IStructureMapping)mapping, linkForPictogramElement).equals(textGa.getValue());
            if (booleanRet) {
                ret = Reason.createTrueReason((String)mapping.getDataMapping().getUpdateWarning(linkForPictogramElement));
            }
        }
        return ret;
    }

    private boolean updateRoot(ContainerShape outerContainerShape) {
        boolean ret = false;
        Object mainBusinessObject = this.getBusinessObjectForPictogramElement((PictogramElement)outerContainerShape);
        int cells = this.getRowCount() * this.getColumnCount();
        if (cells != outerContainerShape.getChildren().size()) {
            Object[] a = outerContainerShape.getChildren().toArray();
            int i = 0;
            while (i < a.length) {
                Graphiti.getPeService().deletePictogramElement((PictogramElement)a[i]);
                ++i;
            }
            this.createCellShapes(outerContainerShape, this.getGridMapping().getLinkCreationInfos(mainBusinessObject));
        }
        this.updateCellShapes(outerContainerShape);
        return ret;
    }

    private void updateCellShapes(ContainerShape outerContainerShape) {
        EList shapes = outerContainerShape.getChildren();
        for (Shape shape : shapes) {
            PictogramLink linkForPictogramElement = Graphiti.getLinkService().getLinkForPictogramElement((PictogramElement)shape);
            if (linkForPictogramElement == null) continue;
            Text textGa = (Text)shape.getGraphicsAlgorithm();
            textGa.setValue(this.getText((IStructureMapping)this.getGridMapping(), linkForPictogramElement));
        }
    }

    private void createCellShapes(ContainerShape containerShape, List<ILinkCreationInfo> linkCreationInfos) {
        IGaService gaService = Graphiti.getGaService();
        for (ILinkCreationInfo linkCreationInfo : linkCreationInfos) {
            Shape shape = Graphiti.getPeCreateService().createShape(containerShape, false);
            Text text = Graphiti.getGaService().createText((GraphicsAlgorithmContainer)shape);
            text.setForeground(this.manageColor(this.getConfiguration().getTextColor()));
            text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setFont(gaService.manageFont(this.getDiagram(), "Baskerville Old Face", 10, true, false));
            this.link((PictogramElement)shape, linkCreationInfo.getBusinessObjects());
            String linkProperty = linkCreationInfo.getProperty();
            if (linkProperty == null) continue;
            Graphiti.getLinkService().setLinkProperty((PictogramElement)shape, linkProperty);
        }
    }

    protected IGridPatternConfiguration getConfiguration() {
        return (IGridPatternConfiguration)this.getPatternConfiguration();
    }

    private int getColumnCount() {
        return this.getGridMapping().getColumns();
    }

    private int getRowCount() {
        return this.getGridMapping().getRows();
    }
}

