/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.pattern.AbstractPattern;
import org.eclipse.graphiti.pattern.AddFeatureForPattern;
import org.eclipse.graphiti.pattern.CreateConnectionFeatureForPattern;
import org.eclipse.graphiti.pattern.CreateFeatureForPattern;
import org.eclipse.graphiti.pattern.DeleteFeatureForPattern;
import org.eclipse.graphiti.pattern.DirectEditingFeatureForPattern;
import org.eclipse.graphiti.pattern.IConnectionPattern;
import org.eclipse.graphiti.pattern.IFeatureProviderWithPatterns;
import org.eclipse.graphiti.pattern.IPattern;
import org.eclipse.graphiti.pattern.LayoutFeatureForPattern;
import org.eclipse.graphiti.pattern.MoveShapeFeatureForPattern;
import org.eclipse.graphiti.pattern.RemoveFeatureForPattern;
import org.eclipse.graphiti.pattern.ResizeShapeFeatureForPattern;
import org.eclipse.graphiti.pattern.UpdateFeatureForPattern;
import org.eclipse.graphiti.pattern.internal.T;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureProviderWithPatterns
extends DefaultFeatureProvider
implements IFeatureProviderWithPatterns {
    private List<IPattern> patterns;
    private List<IConnectionPattern> connectionPatters;

    public DefaultFeatureProviderWithPatterns(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    @Override
    public void addPattern(IPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument pattern must not be null.");
        }
        pattern.setFeatureProvider((IFeatureProvider)this);
        this.getPatterns().add(pattern);
    }

    public void addConnectionPattern(IConnectionPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument pattern must not be null.");
        }
        pattern.setFeatureProvider((IFeatureProvider)this);
        this.getConnectionPatterns().add(pattern);
    }

    protected List<IPattern> getPatterns() {
        if (this.patterns == null) {
            this.patterns = new ArrayList<IPattern>();
        }
        return this.patterns;
    }

    protected List<IConnectionPattern> getConnectionPatterns() {
        if (this.connectionPatters == null) {
            this.connectionPatters = new ArrayList<IConnectionPattern>();
        }
        return this.connectionPatters;
    }

    protected boolean checkFeatureAndContext(IFeature feature, IContext context) {
        boolean featureOkay = feature != null;
        boolean featureAvailable = feature.isAvailable(context);
        boolean ret = featureOkay && featureAvailable;
        return ret;
    }

    public IAddFeature getAddFeature(IAddContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, context.getNewObject())) continue;
            IPattern choosenPattern = null;
            AddFeatureForPattern f = new AddFeatureForPattern((IFeatureProvider)this, pattern);
            boolean executable = this.checkFeatureAndContext((IFeature)f, (IContext)context);
            if (!executable) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getAddFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            for (IConnectionPattern conPattern : this.getConnectionPatterns()) {
                if (!conPattern.canAdd(context)) continue;
                return new AddFeatureForPattern((IFeatureProvider)this, conPattern);
            }
        }
        if (ret == null) {
            ret = this.getAddFeatureAdditional(context);
        }
        return ret;
    }

    protected IAddFeature getAddFeatureAdditional(IAddContext context) {
        return super.getAddFeature(context);
    }

    public ICreateFeature[] getCreateFeatures() {
        ICreateFeature[] a;
        ICreateFeature[] ret = new ICreateFeature[]{};
        ArrayList<CreateFeatureForPattern> retList = new ArrayList<CreateFeatureForPattern>();
        for (IPattern pattern : this.getPatterns()) {
            if (!pattern.isPaletteApplicable()) continue;
            retList.add(new CreateFeatureForPattern((IFeatureProvider)this, pattern));
        }
        ICreateFeature[] iCreateFeatureArray = a = this.getCreateFeaturesAdditional();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature element = iCreateFeatureArray[n2];
            retList.add((CreateFeatureForPattern)element);
            ++n2;
        }
        return retList.toArray(ret);
    }

    protected ICreateFeature[] getCreateFeaturesAdditional() {
        ICreateFeature[] s;
        ICreateFeature[] ret = new ICreateFeature[]{};
        ArrayList<ICreateFeature> retList = new ArrayList<ICreateFeature>();
        ICreateFeature[] iCreateFeatureArray = s = super.getCreateFeatures();
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature element = iCreateFeatureArray[n2];
            retList.add(element);
            ++n2;
        }
        return retList.toArray(ret);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, this.getBusinessObjectForPictogramElement(context.getPictogramElement()))) continue;
            IPattern choosenPattern = null;
            DeleteFeatureForPattern f = new DeleteFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getDeleteFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getDeleteFeatureAdditional(context);
        }
        return ret;
    }

    protected IDeleteFeature getDeleteFeatureAdditional(IDeleteContext context) {
        return super.getDeleteFeature(context);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, this.getBusinessObjectForPictogramElement(context.getPictogramElement()))) continue;
            IPattern choosenPattern = null;
            RemoveFeatureForPattern f = new RemoveFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getRemoveFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getRemoveFeatureAdditional(context);
        }
        return ret;
    }

    protected IRemoveFeature getRemoveFeatureAdditional(IRemoveContext context) {
        return super.getRemoveFeature(context);
    }

    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, this.getBusinessObjectForPictogramElement(context.getPictogramElement()))) continue;
            IPattern choosenPattern = null;
            LayoutFeatureForPattern f = new LayoutFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getLayoutFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getLayoutFeatureAdditional(context);
        }
        return ret;
    }

    protected ILayoutFeature getLayoutFeatureAdditional(ILayoutContext context) {
        return super.getLayoutFeature(context);
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, this.getBusinessObjectForPictogramElement(context.getPictogramElement()))) continue;
            IPattern choosenPattern = null;
            MoveShapeFeatureForPattern f = new MoveShapeFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getMoveShapeFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getMoveShapeFeatureAdditional(context);
        }
        return ret;
    }

    protected IMoveShapeFeature getMoveShapeFeatureAdditional(IMoveShapeContext context) {
        return super.getMoveShapeFeature(context);
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, this.getBusinessObjectForPictogramElement(context.getPictogramElement()))) continue;
            IPattern choosenPattern = null;
            ResizeShapeFeatureForPattern f = new ResizeShapeFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getResizeShapeFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getResizeShapeFeatureAdditional(context);
        }
        return ret;
    }

    protected boolean checkPattern(IPattern pattern, Object object) {
        return pattern.isMainBusinessObjectApplicable(object);
    }

    protected IResizeShapeFeature getResizeShapeFeatureAdditional(IResizeShapeContext context) {
        return super.getResizeShapeFeature(context);
    }

    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        Object businessObject = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, businessObject) && !pattern.canUpdate(context)) continue;
            IPattern choosenPattern = null;
            UpdateFeatureForPattern f = new UpdateFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getUpdateFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getUpdateFeatureAdditional(context);
        }
        return ret;
    }

    protected IUpdateFeature getUpdateFeatureAdditional(IUpdateContext context) {
        return super.getUpdateFeature(context);
    }

    @Override
    public IPattern getPatternForPictogramElement(PictogramElement pe) {
        if (pe == null) {
            throw new IllegalArgumentException("Argument pe must not be null.");
        }
        for (IPattern pattern : this.getPatterns()) {
            AbstractPattern ap;
            if (!(pattern instanceof AbstractPattern) || !(ap = (AbstractPattern)pattern).isPatternRoot(pe)) continue;
            return pattern;
        }
        return null;
    }

    @Override
    public void activateDirectEditingForPatterns(PictogramElement mainPictogramElement, Object domainObject) {
        IPattern pattern = this.getPatternForPictogramElement(mainPictogramElement);
        if (pattern != null) {
            IDirectEditingInfo dei = this.getDirectEditingInfo();
            dei.setMainPictogramElement(mainPictogramElement);
            pattern.completeInfo(dei, domainObject);
            dei.setActive(true);
        }
    }

    @Override
    public void activateDirectEditingForPatterns(PictogramElement mainPictogramElement, Object domainObject, String keyProperty) {
        IPattern pattern = this.getPatternForPictogramElement(mainPictogramElement);
        if (pattern != null) {
            IDirectEditingInfo dei = this.getDirectEditingInfo();
            dei.setMainPictogramElement(mainPictogramElement);
            pattern.completeInfo(dei, domainObject, keyProperty);
            dei.setActive(true);
        }
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        ICreateConnectionFeature[] a;
        ICreateConnectionFeature[] ret = new ICreateConnectionFeature[]{};
        ArrayList<CreateConnectionFeatureForPattern> retList = new ArrayList<CreateConnectionFeatureForPattern>();
        for (IConnectionPattern conPattern : this.getConnectionPatterns()) {
            retList.add(new CreateConnectionFeatureForPattern((IFeatureProvider)this, conPattern));
        }
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = a = this.getCreateConnectionFeaturesAdditional();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature element = iCreateConnectionFeatureArray[n2];
            retList.add((CreateConnectionFeatureForPattern)element);
            ++n2;
        }
        return retList.toArray(ret);
    }

    protected ICreateConnectionFeature[] getCreateConnectionFeaturesAdditional() {
        return super.getCreateConnectionFeatures();
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument context must not be null.");
        }
        Object ret = null;
        for (IPattern pattern : this.getPatterns()) {
            if (!this.checkPattern(pattern, this.getBusinessObjectForPictogramElement(context.getPictogramElement()))) continue;
            IPattern choosenPattern = null;
            DirectEditingFeatureForPattern f = new DirectEditingFeatureForPattern((IFeatureProvider)this, pattern);
            if (!this.checkFeatureAndContext((IFeature)f, (IContext)context)) continue;
            if (ret == null) {
                ret = f;
                choosenPattern = pattern;
                continue;
            }
            this.traceWarning("getDirectEditingFeature", pattern, choosenPattern);
        }
        if (ret == null) {
            ret = this.getDirectEditingFeatureAdditional(context);
        }
        return ret;
    }

    protected IDirectEditingFeature getDirectEditingFeatureAdditional(IDirectEditingContext context) {
        return super.getDirectEditingFeature(context);
    }

    protected void traceWarning(String string, IPattern pattern, IPattern choosenPattern) {
        T.racer().warning(String.valueOf(string) + ": " + "Pattern " + pattern + " is executable additionally to pattern " + choosenPattern + ".");
    }

    public Object getBusinessObjectForPictogramElement(PictogramElement pictogramElement) {
        Property linkProperty;
        Object ret = super.getBusinessObjectForPictogramElement(pictogramElement);
        if (ret == null && (linkProperty = Graphiti.getLinkService().getLinkProperty(pictogramElement)) != null) {
            ret = linkProperty.getValue();
        }
        return ret;
    }
}

