/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveAnchorFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IMoveAnchorContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.AreaAnchorContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.MoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.internal.command.CommandContainer;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.command.MoveShapeFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ResizeShapeFeatureCommandWithContext;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.command.AddModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.CreateModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.command.MoveAnchorFeatureCommandWithContext;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.parts.AdvancedAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.policy.GFResizableEditPolicy;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.viewers.ISelection;

public class ShapeXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private IConfigurationProvider _configurationProvider;

    protected ShapeXYLayoutEditPolicy(IConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected final IConfigurationProvider getConfigurationProvider() {
        return this._configurationProvider;
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        ICommand cmd;
        Object model = child.getModel();
        Rectangle rectangle = this.getHostFigure().getBounds();
        if (model instanceof ConnectionDecorator && constraint instanceof Rectangle && rectangle != null && (cmd = this.getMoveConnectionDecoratorCommand((ConnectionDecorator)model, (Rectangle)constraint, rectangle.x, rectangle.y)) != null) {
            IConfigurationProvider configurationProvider = this.getConfigurationProvider();
            return new GefCommandWrapper(cmd, configurationProvider.getDiagramEditor().getEditingDomain());
        }
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof AdvancedAnchorEditPart) {
            return new GFResizableEditPolicy(this.getConfigurationProvider());
        }
        if (!(child instanceof ShapeEditPart)) {
            return new NonResizableEditPolicy();
        }
        PictogramElement pictogramElement = ((ShapeEditPart)child).getPictogramElement();
        Shape shape = (Shape)pictogramElement;
        ResizeShapeContext resizeShapeContext = new ResizeShapeContext(shape);
        return new GFResizableEditPolicy(this.getConfigurationProvider(), (IResizeShapeContext)resizeShapeContext);
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        IConfigurationProvider configurationProvider = this.getConfigurationProvider();
        IFeatureProvider featureProvider = configurationProvider.getDiagramTypeProvider().getFeatureProvider();
        CommandContainer ret = new CommandContainer(featureProvider);
        Object model = child.getModel();
        if (!(model instanceof EObject) || GraphitiInternal.getEmfService().isObjectAlive((EObject)model)) {
            if (model instanceof ConnectionDecorator) {
                ICommand cmd;
                if (constraint instanceof Rectangle && (cmd = this.getMoveConnectionDecoratorCommand((ConnectionDecorator)model, (Rectangle)constraint, 0, 0)) != null) {
                    ret.add(cmd);
                }
            } else if (model instanceof Anchor) {
                Anchor anchor = (Anchor)model;
                AnchorContainer anchorContainer = anchor.getParent();
                IMoveAnchorContext context = this.createLayoutAnchorContext(anchor, anchorContainer, anchorContainer, constraint);
                IMoveAnchorFeature moveAnchorFeature = featureProvider.getMoveAnchorFeature(context);
                if (moveAnchorFeature != null && child instanceof GraphicalEditPart) {
                    ret.add((ICommand)new MoveAnchorFeatureCommandWithContext(moveAnchorFeature, context, (GraphicalEditPart)child));
                }
            } else if (model instanceof Shape) {
                Shape shape = (Shape)model;
                ContainerShape containerShape = shape.getContainer();
                if (constraint instanceof Rectangle) {
                    IResizeShapeContext context;
                    IResizeShapeFeature resizeShapeFeature;
                    IMoveShapeContext context2;
                    IMoveShapeFeature moveShapeFeature;
                    Polyline polyline;
                    EList points;
                    Rectangle rectangle;
                    Rectangle rc = rectangle = (Rectangle)constraint;
                    if (shape.getGraphicsAlgorithm() instanceof Polyline && (points = (polyline = (Polyline)shape.getGraphicsAlgorithm()).getPoints()).size() > 0) {
                        org.eclipse.graphiti.mm.algorithms.styles.Point firstPoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)points.get(0);
                        int minX = firstPoint.getX();
                        int minY = firstPoint.getY();
                        for (org.eclipse.graphiti.mm.algorithms.styles.Point point : points) {
                            minX = Math.min(point.getX(), minX);
                            minY = Math.min(point.getY(), minY);
                        }
                        if (minX > 0 || minY > 0) {
                            rc = rectangle.getCopy();
                            if (minX > 0) {
                                rc.x -= minX;
                            }
                            if (minY > 0) {
                                rc.y -= minY;
                            }
                        }
                    }
                    if ((moveShapeFeature = featureProvider.getMoveShapeFeature(context2 = this.createMoveShapeContext(shape, containerShape, containerShape, rc))) != null && child instanceof ShapeEditPart && !this.isDifferentSize(shape, rectangle)) {
                        ret.add((ICommand)new MoveShapeFeatureCommandWithContext((IFeature)moveShapeFeature, context2));
                    }
                    if (this.isDifferentSize(shape, rectangle) && (resizeShapeFeature = featureProvider.getResizeShapeFeature(context = this.createResizeShapeContext(shape, constraint, request.getResizeDirection()))) != null) {
                        ret.add((ICommand)new ResizeShapeFeatureCommandWithContext((IFeature)resizeShapeFeature, context));
                    }
                }
            }
        }
        if (ret.containsCommands()) {
            IContextButtonManager contextButtonManager = this.getConfigurationProvider().getContextButtonManager();
            contextButtonManager.hideContextButtonsInstantly();
            DiagramEditor editor = this.getConfigurationProvider().getDiagramEditor();
            return new GefCommandWrapper((ICommand)ret, editor.getEditingDomain());
        }
        return null;
    }

    protected IMoveShapeContext createMoveShapeContext(Shape shape, ContainerShape source, ContainerShape target, Object constraint) {
        MoveShapeContext ret = new MoveShapeContext(shape);
        ret.setSourceContainer(source);
        ret.setTargetContainer(target);
        Point loc = null;
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            loc = rect.getLocation();
        } else if (constraint instanceof Point) {
            loc = (Point)constraint;
        }
        if (loc != null) {
            GraphicsAlgorithm graphicsAlgorithm;
            ret.setX(loc.x);
            ret.setY(loc.y);
            if (shape != null && (graphicsAlgorithm = shape.getGraphicsAlgorithm()) != null) {
                ret.setDeltaX(loc.x - graphicsAlgorithm.getX());
                ret.setDeltaY(loc.y - graphicsAlgorithm.getY());
            }
        }
        return ret;
    }

    protected IResizeShapeContext createResizeShapeContext(Shape shape, Object constraint, int resizeDirection) {
        ResizeShapeContext ret = new ResizeShapeContext(shape);
        Point loc = null;
        Dimension dim = null;
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            dim = rect.getSize();
            loc = rect.getLocation();
        } else if (constraint instanceof Dimension) {
            dim = (Dimension)constraint;
        }
        if (dim != null) {
            ret.setWidth(dim.width);
            ret.setHeight(dim.height);
        }
        if (loc != null) {
            ret.setX(loc.x);
            ret.setY(loc.y);
        }
        int direction = 0;
        switch (resizeDirection) {
            case 1: {
                direction = 1;
                break;
            }
            case 4: {
                direction = 4;
                break;
            }
            case 8: {
                direction = 8;
                break;
            }
            case 16: {
                direction = 16;
                break;
            }
            case 9: {
                direction = 9;
                break;
            }
            case 17: {
                direction = 17;
                break;
            }
            case 12: {
                direction = 12;
                break;
            }
            case 20: {
                direction = 20;
            }
        }
        ret.setDirection(direction);
        return ret;
    }

    protected IMoveAnchorContext createLayoutAnchorContext(Anchor shape, AnchorContainer source, AnchorContainer target, Object constraint) {
        AreaAnchorContext ret = new AreaAnchorContext(shape);
        ret.setSourceContainer(source);
        ret.setTargetContainer(target);
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            ret.setX(rect.x);
            ret.setY(rect.y);
            ret.setWidth(rect.width);
            ret.setHeight(rect.height);
        }
        return ret;
    }

    public static ICreateContext createCreateContext(ContainerShape target, Rectangle rect) {
        CreateContext ret = new CreateContext();
        ret.setTargetContainer(target);
        ret.setX(rect.x);
        ret.setY(rect.y);
        ret.setWidth(rect.width);
        ret.setHeight(rect.height);
        return ret;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object cmd = UnexecutableCommand.INSTANCE;
        Object parentObject = this.getHost().getModel();
        if (!(parentObject instanceof ContainerShape)) {
            return cmd;
        }
        Object createdObject = request.getNewObject();
        Rectangle rectangle = null;
        if (request.getLocation() != null) {
            rectangle = (Rectangle)this.getConstraintFor(request);
        }
        if (request.getNewObjectType() == ICreateFeature.class) {
            ICreateContext context = ShapeXYLayoutEditPolicy.createCreateContext((ContainerShape)parentObject, rectangle);
            this.updateCreateContext((CreateContext)context);
            ICreateFeature createFeature = (ICreateFeature)createdObject;
            cmd = new CreateModelObjectCommand(this.getConfigurationProvider(), createFeature, context, rectangle);
            cmd.setLabel(createFeature.getDescription());
        } else if (request.getNewObjectType() == ISelection.class) {
            cmd = new AddModelObjectCommand(this.getConfigurationProvider(), (ContainerShape)parentObject, (ISelection)createdObject, rectangle);
        }
        return cmd;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    private ICommand getMoveConnectionDecoratorCommand(ConnectionDecorator decorator, Rectangle constraint, int offsetX, int offsetY) {
        GenericFeatureCommandWithContext ret = null;
        int x = constraint.x + offsetX;
        int y = constraint.y + offsetY;
        Connection connection = decorator.getConnection();
        double location = decorator.getLocation();
        if (decorator.isLocationRelative()) {
            Point connectionMidpoint = GraphitiUiInternal.getGefService().getConnectionPointAt(connection, location);
            x -= connectionMidpoint.x;
            y -= connectionMidpoint.y;
        } else {
            Point absolutePointOnConnection = GraphitiUiInternal.getGefService().getAbsolutePointOnConnection(connection, location);
            x -= absolutePointOnConnection.x;
            y -= absolutePointOnConnection.y;
        }
        boolean isExecuteAllowed = true;
        PictogramElement[] selectedPictogramElements = this.getConfigurationProvider().getDiagramEditor().getSelectedPictogramElements();
        List<PictogramElement> pes = Arrays.asList(selectedPictogramElements);
        if (pes.size() > 1) {
            PictogramElement startAnchorContainer = Graphiti.getPeService().getActiveContainerPe((PictogramElement)decorator.getConnection().getStart());
            PictogramElement endAnchorContainer = Graphiti.getPeService().getActiveContainerPe((PictogramElement)decorator.getConnection().getEnd());
            if (pes.contains(startAnchorContainer) || pes.contains(endAnchorContainer)) {
                isExecuteAllowed = false;
            }
        }
        MoveConnectionDecoratorContext context = new MoveConnectionDecoratorContext(decorator, x, y, isExecuteAllowed);
        IMoveConnectionDecoratorFeature feature = this.getFeatureProvider().getMoveConnectionDecoratorFeature((IMoveConnectionDecoratorContext)context);
        if (feature != null) {
            ret = new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context);
        }
        return ret;
    }

    private IFeatureProvider getFeatureProvider() {
        return this.getConfigurationProvider().getFeatureProvider();
    }

    private boolean isDifferentSize(Shape shape, Rectangle constraint) {
        Rectangle rect = constraint;
        IDimension sizeOfGA = Graphiti.getGaService().calculateSize(shape.getGraphicsAlgorithm(), false);
        return rect.width != sizeOfGA.getWidth() || rect.height != sizeOfGA.getHeight();
    }

    private void updateCreateContext(CreateContext ctx) {
        GraphicalViewer viewer = this.getConfigurationProvider().getDiagramEditor().getGraphicalViewer();
        boolean gridVisible = (Boolean)viewer.getProperty("SnapToGrid.isVisible");
        boolean snapToGrid = (Boolean)viewer.getProperty("SnapToGrid.isEnabled");
        if (gridVisible && snapToGrid) {
            Dimension dimension = (Dimension)viewer.getProperty("SnapToGrid.GridSpacing");
            int snappedX = this.getSnapValue(ctx.getX(), dimension.width);
            int snappedY = this.getSnapValue(ctx.getY(), dimension.height);
            ctx.setX(snappedX);
            ctx.setY(snappedY);
        }
    }

    private int getSnapValue(int currentValue, int gridUnit) {
        int units = currentValue / gridUnit;
        if (currentValue % gridUnit > gridUnit / 2) {
            ++units;
        }
        return gridUnit * units;
    }
}

