/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial;

import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.PredefinedColoredAreas;

public class StyleUtil {
    private static final IColorConstant E_CLASS_TEXT_FOREGROUND = new ColorConstant(0, 0, 0);
    private static final IColorConstant E_CLASS_FOREGROUND = new ColorConstant(98, 131, 167);

    public static Style getStyleForCommonValues(Diagram diagram) {
        String styleId = "COMMON-VALUES";
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)diagram, "COMMON-VALUES");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)diagram, "COMMON-VALUES");
            StyleUtil.setCommonValues(style);
        }
        return style;
    }

    public static Style getStyleForEClass(Diagram diagram) {
        Style parentStyle;
        String styleId = "E-CLASS";
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram)), "E-CLASS");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "E-CLASS");
            style.setFilled(Boolean.valueOf(true));
            style.setForeground(gaService.manageColor(diagram, E_CLASS_FOREGROUND));
            gaService.setRenderingStyle((AbstractStyle)style, PredefinedColoredAreas.getBlueWhiteGlossAdaptions());
        }
        return style;
    }

    public static Style getStyleForEClassText(Diagram diagram) {
        Style parentStyle;
        String styleId = "ECLASS-TEXT";
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram)), "ECLASS-TEXT");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "ECLASS-TEXT");
            StyleUtil.setCommonTextValues(diagram, gaService, style);
            style.setFont(gaService.manageDefaultFont(diagram, false, true));
        }
        return style;
    }

    public static Style getStyleForTextDecorator(Diagram diagram) {
        Style parentStyle;
        String styleId = "TEXT-DECORATOR-TEXT";
        IGaService gaService = Graphiti.getGaService();
        Style style = gaService.findStyle((StyleContainer)(parentStyle = StyleUtil.getStyleForCommonValues(diagram)), "TEXT-DECORATOR-TEXT");
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)parentStyle, "TEXT-DECORATOR-TEXT");
            StyleUtil.setCommonTextValues(diagram, gaService, style);
            style.setFont(gaService.manageDefaultFont(diagram, true, false));
        }
        return style;
    }

    private static void setCommonTextValues(Diagram diagram, IGaService gaService, Style style) {
        style.setFilled(Boolean.valueOf(false));
        style.setAngle(Integer.valueOf(0));
        style.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        style.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        style.setForeground(gaService.manageColor(diagram, E_CLASS_TEXT_FOREGROUND));
    }

    private static void setCommonValues(Style style) {
        style.setLineStyle(LineStyle.SOLID);
        style.setLineVisible(Boolean.valueOf(true));
        style.setLineWidth(Integer.valueOf(2));
        style.setTransparency(Double.valueOf(0.0));
    }
}

