/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.swt.widgets.Display;

public class DomainModelChangeListener
implements ResourceSetListener {
    private IDiagramEditor diagramEditor;

    public DomainModelChangeListener(IDiagramEditor diagramEditor) {
        this.setDiagramEditor(diagramEditor);
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.NOT_TOUCH;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (diagram != null && diagram.getPictogramLinks().size() == 0) {
            return;
        }
        HashSet<EObject> changedBOs = new HashSet<EObject>();
        List notifications = event.getNotifications();
        for (Notification notification : notifications) {
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject)) continue;
            changedBOs.add((EObject)notifier);
        }
        final PictogramElement[] dirtyPes = this.getDiagramTypeProvider().getNotificationService().calculateRelatedPictogramElements(changedBOs.toArray());
        if (dirtyPes.length == 0) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (DomainModelChangeListener.this.getDiagramTypeProvider().isAutoUpdateAtRuntime()) {
                    if (DomainModelChangeListener.this.getDiagramTypeProvider().isAutoUpdateAtRuntimeWhenEditorIsSaved() || DomainModelChangeListener.this.getDiagramTypeProvider().getDiagramEditor().isDirty()) {
                        DomainModelChangeListener.this.getDiagramTypeProvider().getNotificationService().updatePictogramElements(dirtyPes);
                    }
                } else {
                    DomainModelChangeListener.this.getDiagramTypeProvider().getDiagramEditor().refresh();
                }
            }
        });
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    private IDiagramTypeProvider getDiagramTypeProvider() {
        return this.getDiagramEditor().getDiagramTypeProvider();
    }

    private IDiagramEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    private void setDiagramEditor(IDiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
    }
}

