/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.ui.IEditorInput;

public class DomainModelWorkspaceSynchronizerDelegate
implements WorkspaceSynchronizer.Delegate {
    private DiagramEditor diagramEditor;

    public DomainModelWorkspaceSynchronizerDelegate(DiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
    }

    public void dispose() {
        this.diagramEditor = null;
    }

    public boolean handleResourceChanged(Resource resource) {
        IFile file = WorkspaceSynchronizer.getUnderlyingFile((Resource)resource);
        if (file == null) {
            this.diagramEditor.getUpdateBehavior().setResourceChanged(true);
            return true;
        }
        if (file.getLocalTimeStamp() != resource.getTimeStamp()) {
            this.diagramEditor.getUpdateBehavior().setResourceChanged(true);
            return true;
        }
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        return false;
    }

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        resource.setURI(newURI);
        IEditorInput editorInput = this.diagramEditor.getEditorInput();
        if (editorInput instanceof IDiagramEditorInput) {
            ((IDiagramEditorInput)editorInput).updateUri(newURI);
        }
        this.diagramEditor.refreshContent();
        return true;
    }
}

