/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.ui;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class CreateSampleProjectWizard
extends BasicNewProjectResourceWizard {
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        IProject newProject = this.getNewProject();
        try {
            IProjectDescription description = newProject.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.graphiti.examples.examplesnature"});
            newProject.setDescription(description, null);
            this.createPredefinedContent(newProject);
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    private void createPredefinedContent(IProject newProject) throws CoreException {
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("PredefinedEClass");
        ResourceSetImpl set = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)newProject.getFolder("src").getFile("Predefined.data").getFullPath().toString(), (boolean)true);
        Resource resource = set.createResource(uri);
        resource.getContents().add((Object)eclass);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.tutorial.support", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

