/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.examples.tutorial.StyleUtil;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class TutorialAddEClassFeature
extends AbstractAddShapeFeature {
    public static final int INVISIBLE_RECT_RIGHT = 6;

    public TutorialAddEClassFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object newObject = context.getNewObject();
        return newObject instanceof EClass && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        EClass addedClass = (EClass)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        int width = context.getWidth() <= 0 ? 100 : context.getWidth();
        int height = context.getHeight() <= 0 ? 50 : context.getHeight();
        IGaService gaService = Graphiti.getGaService();
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width + 6, height);
        RoundedRectangle roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 5, 5);
        roundedRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)invisibleRectangle);
        roundedRectangle.setStyle(StyleUtil.getStyleForEClass(this.getDiagram()));
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, 0, 0, width, height);
        if (addedClass.eResource() == null) {
            this.getDiagram().eResource().getContents().add((Object)addedClass);
        }
        this.link((PictogramElement)containerShape, addedClass);
        Shape shape = peCreateService.createShape(containerShape, false);
        int[] nArray = new int[4];
        nArray[1] = 20;
        nArray[2] = width;
        nArray[3] = 20;
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)shape, nArray);
        polyline.setStyle(StyleUtil.getStyleForEClass(this.getDiagram()));
        shape = peCreateService.createShape(containerShape, false);
        Text text = gaService.createDefaultText((GraphicsAlgorithmContainer)shape, addedClass.getName());
        text.setStyle(StyleUtil.getStyleForEClassText(this.getDiagram()));
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.getFont().setBold(true);
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, width, 20);
        this.link((PictogramElement)shape, addedClass);
        IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)shape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        BoxRelativeAnchor boxAnchor = peCreateService.createBoxRelativeAnchor((AnchorContainer)containerShape);
        boxAnchor.setRelativeWidth(1.0);
        boxAnchor.setRelativeHeight(0.38);
        boxAnchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)roundedRectangle);
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)boxAnchor);
        ellipse.setFilled(Boolean.valueOf(true));
        int w = 6;
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, -6, -6, 12, 12);
        ellipse.setStyle(StyleUtil.getStyleForEClass(this.getDiagram()));
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }
}

