/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.examples.common.ExampleUtil;
import org.eclipse.graphiti.examples.tutorial.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class TutorialChangeColorEClassFeature
extends AbstractCustomFeature {
    private boolean background;

    public TutorialChangeColorEClassFeature(IFeatureProvider fp, boolean background) {
        super(fp);
        this.background = background;
    }

    public String getName() {
        String colorType = this.background ? "&background" : "&foreground";
        return "Change " + colorType + " color";
    }

    public String getDescription() {
        String colorType = this.background ? "background" : "foreground";
        return "Change the " + colorType + " color";
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes == null || pes.length == 0) {
            return false;
        }
        PictogramElement[] pictogramElementArray = pes;
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (!(bo instanceof EClass)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void execute(ICustomContext context) {
        Style style = StyleUtil.getStyleForEClass(this.getDiagram());
        Color currentColor = this.background ? style.getBackground() : style.getForeground();
        Color newColor = ExampleUtil.editColor((Color)currentColor);
        if (newColor == null) {
            return;
        }
        if (this.background) {
            style.setBackground(newColor);
        } else {
            style.setForeground(newColor);
        }
    }
}

