/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.ui.internal.command.AbstractCommand;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AddModelObjectCommand
extends AbstractCommand {
    private List<AddContext> contextList;

    public AddModelObjectCommand(IConfigurationProvider configurationProvider, ContainerShape parent, ISelection sel, Rectangle rectangle) {
        this(configurationProvider, parent, sel, rectangle, null);
    }

    public AddModelObjectCommand(IConfigurationProvider configurationProvider, ContainerShape parent, ISelection sel, Rectangle rectangle, Connection connection) {
        super(configurationProvider);
        IStructuredSelection s = (IStructuredSelection)sel;
        if (s == null) {
            s = StructuredSelection.EMPTY;
        }
        this.contextList = new ArrayList<AddContext>();
        int x = rectangle.x;
        int y = rectangle.y;
        for (Object next : s) {
            IAdaptable adaptable;
            Object adapter;
            if (next instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)next).getAdapter(EObject.class)) instanceof EObject) {
                next = adapter;
            }
            AddContext ctx = new AddContext();
            ctx.setNewObject(next);
            ctx.setTargetContainer(parent);
            ctx.setLocation(x, y);
            ctx.setTargetConnection(connection);
            this.contextList.add(ctx);
            x += 10;
            y += 10;
        }
    }

    public boolean canExecute() {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider != null && this.contextList.size() > 0) {
            for (IAddContext iAddContext : this.contextList) {
                IAddFeature f = featureProvider.getAddFeature(iAddContext);
                if (f == null) {
                    return false;
                }
                boolean canAdd = f.canAdd(iAddContext);
                if (!canAdd) continue;
                return true;
            }
        }
        return false;
    }

    public void execute() {
        for (IAddContext iAddContext : this.contextList) {
            this.getFeatureProvider().addIfPossible(iAddContext);
        }
    }

    public boolean canUndo() {
        return false;
    }

    public IAddFeature[] getAddFeatures() {
        ArrayList<IAddFeature> features = new ArrayList<IAddFeature>();
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider != null && this.contextList.size() > 0) {
            for (IAddContext iAddContext : this.contextList) {
                IAddFeature f = featureProvider.getAddFeature(iAddContext);
                if (f == null || !f.canAdd(iAddContext)) continue;
                features.add(f);
            }
        }
        return features.toArray(new IAddFeature[features.size()]);
    }
}

