/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.internal.command.CommandExec;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.events.KeyEvent;

public class GFConnectionCreationTool
extends ConnectionCreationTool {
    public GFConnectionCreationTool() {
    }

    public GFConnectionCreationTool(CreationFactory factory) {
        super(factory);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        List list;
        Object object = this.getFactory().getNewObject();
        if (object instanceof List && (list = (List)object).size() > 0) {
            object = list.get(0);
        }
        if (object instanceof ICreateConnectionFeature) {
            ICreateConnectionFeature createFeature = (ICreateConnectionFeature)object;
            CreateConnectionContext context = new CreateConnectionContext();
            IFeatureProvider featureProvider = createFeature.getFeatureProvider();
            IDiagramTypeProvider diagramTypeProvider = featureProvider.getDiagramTypeProvider();
            PictogramElement[] selectedPictogramElements = diagramTypeProvider.getDiagramEditor().getSelectedPictogramElements();
            if (selectedPictogramElements.length == 2) {
                PictogramElement sourcePictogramElement = selectedPictogramElements[0];
                Anchor sourceAnchor = this.getAnchor(sourcePictogramElement);
                PictogramElement targetPictogramElement = selectedPictogramElements[1];
                Anchor targetAnchor = this.getAnchor(targetPictogramElement);
                context.setSourcePictogramElement(sourcePictogramElement);
                context.setSourceAnchor(sourceAnchor);
                context.setTargetPictogramElement(targetPictogramElement);
                context.setTargetAnchor(targetAnchor);
                if (createFeature.canExecute((IContext)context)) {
                    CommandExec.executeFeatureWithContext((IFeature)createFeature, (IContext)context);
                }
            }
        }
        this.eraseTargetFeedback();
        this.unlockTargetEditPart();
        return true;
    }

    private Anchor getAnchor(PictogramElement sourcePictogramElement) {
        EList anchors;
        if (sourcePictogramElement instanceof AnchorContainer && (anchors = ((AnchorContainer)sourcePictogramElement).getAnchors()).size() > 0) {
            for (Anchor anchor : anchors) {
                if (!(anchor instanceof ChopboxAnchor)) continue;
                return anchor;
            }
            return (Anchor)anchors.get(0);
        }
        return null;
    }
}

