/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.command;

import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;

public class DirectEditingFeatureCommandWithContext
extends GenericFeatureCommandWithContext {
    private String newValue;

    public DirectEditingFeatureCommandWithContext(IDirectEditingFeature feature, IDirectEditingContext context, String valueObject) {
        super(feature, context);
        this.setNewValue(valueObject);
    }

    private String getNewValue() {
        return this.newValue;
    }

    private void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Override
    public boolean execute() {
        boolean ret = false;
        if (this.getFeature() instanceof IDirectEditingFeature && this.getContext() instanceof IDirectEditingContext) {
            IDirectEditingContext dec;
            IDirectEditingFeature def = (IDirectEditingFeature)this.getFeature();
            String initialValue = def.getInitialValue(dec = (IDirectEditingContext)this.getContext());
            if (initialValue == null) {
                initialValue = "";
            }
            if (!initialValue.equals(this.getNewValue())) {
                def.setValue(this.getNewValue(), dec);
                ret = true;
                if (this.getFeature() instanceof AbstractDirectEditingFeature) {
                    ((AbstractDirectEditingFeature)this.getFeature()).setValueChanged();
                }
            }
        }
        return ret;
    }
}

