/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class DiagramEditorInput
implements IEditorInput,
IPersistableElement {
    public static final String KEY_URI = "org.eclipse.graphiti.uri";
    public static final String KEY_OBJECT_NAME = "org.eclipse.graphiti.objectName";
    public static String KEY_PROVIDER_ID = "org.eclipse.graphiti.providerId";
    private final String uriName;
    private URI normalizedUri;
    private String providerId;
    private String name;
    private String tooltip;
    protected TransactionalEditingDomain editingDomain;
    private boolean disposeEditingDomain;

    public DiagramEditorInput(String diagramUriString, TransactionalEditingDomain domain, String providerId) {
        this(diagramUriString, domain, providerId, false);
    }

    public DiagramEditorInput(String diagramUriString, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        if (diagramUriString == null) {
            throw new IllegalStateException("diagramUriString must not be null");
        }
        this.uriName = diagramUriString;
        this.setEditorEditingDomain(domain);
        this.disposeEditingDomain = disposeEditingDomain;
        this.setProviderId(providerId);
        this.normalizedUri = this.createNormalizedUri();
    }

    public DiagramEditorInput(URI diagramUri, TransactionalEditingDomain domain, String providerId) {
        this(diagramUri, domain, providerId, false);
    }

    public DiagramEditorInput(URI diagramUri, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        if (diagramUri == null) {
            throw new IllegalStateException("diagramUri must not be null");
        }
        this.uriName = diagramUri.toString();
        this.setEditorEditingDomain(domain);
        this.disposeEditingDomain = disposeEditingDomain;
        this.setProviderId(providerId);
        this.normalizedUri = this.createNormalizedUri();
    }

    public static DiagramEditorInput createEditorInput(Diagram diagram, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        Resource resource = diagram.eResource();
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        String fragment = resource.getURIFragment((EObject)diagram);
        URI fragmentUri = resource.getURI().appendFragment(fragment);
        DiagramEditorInput diagramEditorInput = disposeEditingDomain ? new DiagramEditorInput(fragmentUri, domain, providerId, true) : new DiagramEditorInput(fragmentUri, domain, providerId);
        return diagramEditorInput;
    }

    public Diagram getDiagram() {
        return (Diagram)this.getAdapter(Diagram.class);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getFactoryId() {
        return DiagramEditorFactory.class.getName();
    }

    public void dispose() {
        if (this.disposeEditingDomain && this.editingDomain != null) {
            this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    DiagramEditorInput.this.editingDomain.getResourceSet().getResources().retainAll((Collection)Collections.EMPTY_LIST);
                }
            });
            this.editingDomain.dispose();
            this.editingDomain = null;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.uriName;
    }

    protected boolean hasName() {
        return this.name != null;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getToolTipText() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        return this.getName();
    }

    protected String getLiveName() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            return diagram.getName();
        }
        EObject object = this.getEObject();
        if (object != null) {
            String name = GraphitiUiInternal.getEmfService().getObjectName(object);
            return name;
        }
        return null;
    }

    protected String getLiveToolTipText() {
        String id;
        Diagram diagram = this.getDiagram();
        if (diagram != null && diagram.getDiagramTypeId() != null && (id = diagram.getDiagramTypeId()) != null) {
            String tip = this.getLiveName();
            tip = String.valueOf(tip) + " (" + id + ")";
            return tip;
        }
        EObject object = this.getEObject();
        if (object != null) {
            String name = this.getLiveName();
            String typeName = object.eClass().getName();
            String tip = String.valueOf(name) + " (" + typeName + ")";
            return tip;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (Diagram.class.isAssignableFrom(adapter)) {
            EObject obj = this.getEObject();
            if (obj instanceof Diagram) {
                return obj;
            }
        } else {
            if (EObject.class.isAssignableFrom(adapter)) {
                EObject eObject = null;
                try {
                    eObject = this.getEObject(adapter);
                }
                catch (Exception e) {
                    T.racer().debug(e.getMessage());
                    return null;
                }
                return eObject;
            }
            if (TransactionalEditingDomain.class.isAssignableFrom(adapter)) {
                return this.getEditingDomain();
            }
            if (ResourceSet.class.isAssignableFrom(adapter)) {
                return this.getEditingDomain().getResourceSet();
            }
        }
        return null;
    }

    public void saveState(IMemento memento) {
        boolean exists = this.exists();
        if (!exists) {
            return;
        }
        memento.putString(KEY_URI, this.uriName);
        memento.putString(KEY_OBJECT_NAME, this.getName());
        memento.putString(KEY_PROVIDER_ID, this.providerId);
    }

    private void setEditorEditingDomain(TransactionalEditingDomain editingDomain) {
        if (editingDomain == null) {
            throw new IllegalArgumentException("EditingDomain must not be null");
        }
        this.editingDomain = editingDomain;
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack == null || !(commandStack instanceof IWorkspaceCommandStack)) {
            throw new IllegalStateException("Command stack of the editing domain must be an IWorkspaceCommandStack");
        }
        EObject obj = this.getEObject(EObject.class);
        if (obj != null) {
            if (this.name == null) {
                this.name = this.getLiveName();
            } else {
                String newName = this.getLiveName();
                if (newName != null) {
                    this.name = newName;
                }
            }
            this.tooltip = this.getLiveToolTipText();
        }
    }

    public final EObject getEObject() {
        EObject object = this.getEObject(EObject.class);
        return object;
    }

    public final String getUriString() {
        return this.uriName;
    }

    public boolean exists() {
        if (this.uriName == null) {
            return false;
        }
        URI uri = this.getUri();
        if (uri == null) {
            return false;
        }
        EObject eObject = null;
        try {
            eObject = this.getEObject();
        }
        catch (Exception e) {
            return false;
        }
        return eObject != null;
    }

    public IPersistableElement getPersistable() {
        DiagramEditorInput element = null;
        EObject obj = null;
        try {
            obj = this.getEObject();
        }
        catch (WrappedException wrappedException) {
            // empty catch block
        }
        if (obj != null) {
            element = this;
        }
        return element;
    }

    private EObject getEObject(Class<EObject> adapter) {
        TransactionalEditingDomain editingDomain;
        URI uri = this.getUri();
        if (uri != null && (editingDomain = this.getEditingDomain()) != null) {
            EObject modelElement = editingDomain.getResourceSet().getEObject(uri, false);
            if (modelElement == null && (modelElement = editingDomain.getResourceSet().getEObject(uri, true)) == null) {
                return null;
            }
            modelElement.eResource().setTrackingModification(true);
            int i = 0;
            EObject o = modelElement;
            do {
                if (!adapter.isAssignableFrom(o.getClass())) continue;
                return o;
            } while ((o = o.eContainer()) != null && ++i < 1000);
        }
        return null;
    }

    private URI getUri() {
        if (this.uriName == null) {
            return null;
        }
        URI uri = URI.createURI((String)this.uriName);
        return uri;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramEditorInput other = (DiagramEditorInput)obj;
        if (this.normalizedUri == null ? other.normalizedUri != null : !this.normalizedUri.equals((Object)other.normalizedUri)) {
            return false;
        }
        return !(this.providerId == null ? other.providerId != null : !this.providerId.equals(other.providerId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.normalizedUri == null ? 0 : this.normalizedUri.hashCode());
        result = 31 * result + (this.providerId == null ? 0 : this.providerId.hashCode());
        return result;
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + " uriName: " + this.uriName + " on TransactionalEditingDomain " + String.valueOf(this.getEditingDomain()) + " (null=OK)";
        return s;
    }

    private URI createNormalizedUri() {
        URIConverter uriConverter;
        URI ret = null;
        if (this.getEditingDomain() != null && this.getEditingDomain().getResourceSet() != null && (uriConverter = this.getEditingDomain().getResourceSet().getURIConverter()) != null) {
            ret = uriConverter.normalize(this.getUri());
        }
        return ret;
    }
}

