/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.parts.ConnectionDecoratorEditPart;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.ui.progress.UIJob;

class DiagramRefreshJob
extends UIJob {
    private final String UIJOB_FAMILY_REFRESH = "org.eclipse.graphiti.ui.internal.refresh";
    private final Set<EditPart> editParts = new HashSet<EditPart>();
    private boolean refreshAll = false;
    private DiagramEditorInternal ed;

    DiagramRefreshJob(String name, DiagramEditorInternal ed) {
        super(name);
        this.ed = ed;
    }

    void addEditPart(EditPart ep) {
        if (ep instanceof DiagramEditPart) {
            this.setRefreshAll();
            return;
        }
        this.editParts.add(ep);
    }

    boolean shouldBeRun() {
        return this.isRefreshAll() || !this.editParts.isEmpty();
    }

    public boolean belongsTo(Object family) {
        return "org.eclipse.graphiti.ui.internal.refresh".equals(family);
    }

    boolean isRefreshAll() {
        return this.refreshAll;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (GFPreferences.getInstance().isCPUProfilingTraceActive() && T.racer().info()) {
            T.racer().info("RUN UI  =>  DiagramEditorInternal.RefreshDiagramJob.runInUIThread()");
        }
        this.ed.initRefresh();
        IDirectEditingInfo dei = this.ed.getConfigurationProvider().getFeatureProvider().getDirectEditingInfo();
        if (this.refreshAll || dei.isActive()) {
            this.ed.refresh();
        } else {
            for (EditPart ep : this.editParts) {
                if (this.hasNewParent(ep)) continue;
                this.ed.internalRefreshEditPart(ep);
            }
            Set entrySet = this.ed.getGraphicalViewer().getEditPartRegistry().entrySet();
            for (Map.Entry e : entrySet) {
                Object value = e.getValue();
                if (!(value instanceof ConnectionDecoratorEditPart)) continue;
                EditPart ep = (EditPart)value;
                ep.refresh();
            }
            this.ed.selectBufferedPictogramElements();
        }
        this.refreshAll = false;
        this.editParts.clear();
        return Status.OK_STATUS;
    }

    private boolean hasNewParent(EditPart ep) {
        EObject eo;
        if (ep == null || !(ep instanceof ShapeEditPart) || ep instanceof DiagramEditPart || ep instanceof ConnectionDecoratorEditPart) {
            return false;
        }
        if (ep.getParent() == null) {
            return true;
        }
        Object parentModel = ep.getParent().getModel();
        return parentModel != null && ep.getModel() instanceof EObject && !parentModel.equals((eo = (EObject)ep.getModel()).eContainer());
    }

    void setRefreshAll() {
        this.refreshAll = true;
    }
}

