/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.partfactory;

import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.ManhattanConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.internal.config.AbstractConfigurationProviderHolder;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.config.IEditPartFactory;
import org.eclipse.graphiti.ui.internal.parts.BoxRelativeAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.ConnectionDecoratorEditPart;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.graphiti.ui.internal.parts.FixPointAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.FreeFormConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IAnchorContainerEditPart;
import org.eclipse.graphiti.ui.internal.parts.ManhattanConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;

public class PictogramsEditPartFactory
extends AbstractConfigurationProviderHolder
implements IEditPartFactory {
    public PictogramsEditPartFactory(IConfigurationProvider configurationProvider) {
        super(configurationProvider);
    }

    public EditPart createEditPart(EditPart context, Object model) {
        Shape shape;
        IAnchorContainerEditPart ret = null;
        IConfigurationProvider configurationProvider = this.getConfigurationProvider();
        Map epRegistry = this.getConfigurationProvider().getDiagramEditor().getGraphicalViewer().getEditPartRegistry();
        if (epRegistry != null && epRegistry.containsKey(model)) {
            T.racer().warning("PictogramsEditPartFactory.createEditPart()", "edit part for this model already exists");
        }
        if (model instanceof Shape && !((shape = (Shape)model) instanceof Diagram) && !shape.isActive()) {
            ret = new ShapeEditPart(configurationProvider, shape);
        }
        if (ret == null) {
            if (model instanceof Diagram) {
                ret = new DiagramEditPart(configurationProvider, (Diagram)model);
            } else if (model instanceof ConnectionDecorator) {
                ret = new ConnectionDecoratorEditPart(configurationProvider, (Shape)model);
            } else if (model instanceof ContainerShape) {
                ret = new ContainerShapeEditPart(configurationProvider, (ContainerShape)model);
            } else if (model instanceof Shape) {
                ret = new ShapeEditPart(configurationProvider, (Shape)model);
            } else if (model instanceof ManhattanConnection) {
                ret = new ManhattanConnectionEditPart(configurationProvider, (Connection)((ManhattanConnection)model));
            } else if (model instanceof FreeFormConnection) {
                ret = new FreeFormConnectionEditPart(configurationProvider, (Connection)((FreeFormConnection)model));
            } else if (model instanceof FixPointAnchor) {
                ret = new FixPointAnchorEditPart(configurationProvider, (FixPointAnchor)model);
            } else if (model instanceof BoxRelativeAnchor) {
                ret = new BoxRelativeAnchorEditPart(configurationProvider, (BoxRelativeAnchor)model);
            }
        }
        return ret;
    }
}

