/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui.sfx;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.graphiti.ui.internal.IDisposable;
import org.eclipse.graphiti.ui.internal.policy.ResourceManagingGraphicalEditPolicy;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class GFSnapFeedbackPolicy
extends ResourceManagingGraphicalEditPolicy {
    IFigure[] guide = new IFigure[6];
    Integer[] location = new Integer[6];

    public void eraseTargetFeedback(Request request) {
        int i = 0;
        while (i < this.guide.length) {
            if (this.guide[i] != null) {
                this.removeFeedback(this.guide[i]);
            }
            this.guide[i] = null;
            this.location[i] = null;
            ++i;
        }
    }

    void highlightGuide(Integer pos, Color color, int offset) {
        if (pos == null) {
            if (this.guide[offset] != null) {
                this.removeFeedback(this.guide[offset]);
                this.guide[offset] = null;
            }
            this.location[offset] = pos;
            return;
        }
        int position = pos;
        PrecisionPoint loc = new PrecisionPoint(position, position);
        IFigure contentPane = ((GraphicalEditPart)this.getHost()).getContentPane();
        contentPane.translateToParent((Translatable)loc);
        contentPane.translateToAbsolute((Translatable)loc);
        if (this.location[offset] == null || !this.location[offset].equals(pos)) {
            this.location[offset] = pos;
            if (this.guide[offset] != null) {
                this.removeFeedback(this.guide[offset]);
                this.guide[offset] = null;
            }
            FadeIn fig = new FadeIn(color);
            this.guide[offset] = fig;
            this.addFeedback((IFigure)fig);
            fig.translateToRelative((Translatable)loc);
            position = offset % 2 == 0 ? (int)Math.round(loc.preciseX) : (int)Math.round(loc.preciseY);
            Rectangle figBounds = this.getFeedbackLayer().getBounds().getCopy();
            if (offset % 2 == 1) {
                figBounds.height = 2;
                figBounds.y = position;
            } else {
                figBounds.x = position;
                figBounds.width = 2;
            }
            fig.setBounds(figBounds);
        } else {
            IFigure fig = this.guide[offset];
            Rectangle figBounds = fig.getBounds().getCopy();
            Rectangle feedbackBounds = this.getFeedbackLayer().getBounds();
            if (offset % 2 == 1) {
                figBounds.x = feedbackBounds.x;
                figBounds.width = feedbackBounds.width;
            } else {
                figBounds.y = feedbackBounds.y;
                figBounds.height = feedbackBounds.height;
            }
            fig.setBounds(figBounds);
        }
    }

    public void showTargetFeedback(Request req) {
        if (req.getType().equals("move") || req.getType().equals("resize") || req.getType().equals("clone") || req.getType().equals("add children") || req.getType().equals("create child")) {
            Integer value = (Integer)req.getExtendedData().get("SnapToGeometry.WestAnchor");
            this.highlightGuide(value, GFColorConstants.HANDLE_BG, 0);
            value = (Integer)req.getExtendedData().get("SnapToGeometry.NorthAnchor");
            this.highlightGuide(value, GFColorConstants.HANDLE_BG, 1);
            value = (Integer)req.getExtendedData().get("SnapToGeometry.EastAnchor");
            this.highlightGuide(value, GFColorConstants.HANDLE_BG, 2);
            value = (Integer)req.getExtendedData().get("SnapToGeometry.SouthAnchor");
            this.highlightGuide(value, GFColorConstants.HANDLE_BG, 3);
            value = (Integer)req.getExtendedData().get("SnapToGuides.VerticalGuide");
            this.highlightGuide(value, ColorConstants.red, 4);
            value = (Integer)req.getExtendedData().get("SnapToGuides.HorizontalGuide");
            this.highlightGuide(value, ColorConstants.red, 5);
        }
    }

    protected void removeFeedback(IFigure figure) {
        super.removeFeedback(figure);
        this.disposeFigure(figure);
    }

    class FadeIn
    extends Figure
    implements IDisposable {
        int opacity = 0;
        static final int FRAMES = 6;
        Image image;
        int count;

        FadeIn(Color bg) {
            this.setBackgroundColor(bg);
            super.setOpaque(true);
        }

        public Color getLocalBackgroundColor() {
            Color localBackgroundColor = super.getLocalBackgroundColor();
            Color parentBackgroundColor = this.getParent().getBackgroundColor();
            Color temp = FigureUtilities.mixColors((Color)localBackgroundColor, (Color)parentBackgroundColor, (double)((double)this.opacity / 6.0));
            Color mixColors = GFSnapFeedbackPolicy.this.manageColor(temp);
            return mixColors;
        }

        protected void paintFigure(Graphics graphics) {
            if (this.opacity != 6) {
                if (this.image != null) {
                    this.image.dispose();
                    --this.count;
                    this.image = null;
                }
                if (this.opacity != 5) {
                    Display display = Display.getCurrent();
                    PaletteData pData = new PaletteData(255, 65280, 0xFF0000);
                    int fillColor = pData.getPixel(this.getLocalBackgroundColor().getRGB());
                    ImageData iData = new ImageData(1, 1, 24, pData);
                    iData.setPixel(0, 0, fillColor);
                    iData.setAlpha(0, 0, 255 * this.opacity / 6);
                    this.image = new Image((Device)display, iData);
                    ++this.count;
                }
                Display.getCurrent().timerExec(100, new Runnable(){

                    @Override
                    public void run() {
                        FadeIn.this.opacity = Math.min(6, FadeIn.this.opacity + 1);
                        FadeIn.this.repaint();
                    }
                });
            }
            Rectangle r = this.getBounds();
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, 1, 1, r.x, r.y, r.width, r.height);
            } else {
                super.paintFigure(graphics);
            }
        }

        public void removeNotify() {
            if (this.image != null) {
                this.image.dispose();
                --this.count;
                this.image = null;
            }
        }

        @Override
        public void dispose() {
            GFSnapFeedbackPolicy.this.getResourceRegistry().dispose();
        }
    }
}

