/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.PredefinedColoredAreas;

public class StyleUtil {
    private static final IColorConstant E_CLASS_TEXT_FOREGROUND = new ColorConstant(51, 51, 153);
    private static final IColorConstant E_CLASS_FOREGROUND = new ColorConstant(255, 102, 0);
    private static String DEFAULT_FONT = "Arial";

    public static Style getStyleForEClass(Diagram diagram) {
        String styleId = "E-CLASS";
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "E-CLASS");
        IGaService gaService = Graphiti.getGaService();
        if (style == null) {
            style = gaService.createStyle((StyleContainer)diagram, "E-CLASS");
            style.setForeground(gaService.manageColor(diagram, E_CLASS_FOREGROUND));
            gaService.setRenderingStyle((AbstractStyle)style, PredefinedColoredAreas.getBlueWhiteGlossAdaptions());
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForEClassText(Diagram diagram) {
        String styleId = "ECLASS-TEXT";
        Style parentStyle = StyleUtil.getStyleForEClass(diagram);
        Style style = StyleUtil.findStyle((StyleContainer)parentStyle, "ECLASS-TEXT");
        if (style == null) {
            IGaService gaService = Graphiti.getGaService();
            style = gaService.createStyle((StyleContainer)StyleUtil.getStyleForEClass(diagram), "ECLASS-TEXT");
            style.setForeground(gaService.manageColor(diagram, E_CLASS_TEXT_FOREGROUND));
            style.setFont(gaService.manageFont(diagram, DEFAULT_FONT, 8, false, true));
        }
        return style;
    }

    private static Style findStyle(StyleContainer styleContainer, String id) {
        EList styles = styleContainer.getStyles();
        if (styles != null) {
            for (Style style : styles) {
                if (!id.equals(style.getId())) continue;
                return style;
            }
        }
        return null;
    }
}

