/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.diagram;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.examples.tutorial.features.TutorialCollapseDummyFeature;
import org.eclipse.graphiti.examples.tutorial.features.TutorialRenameEClassFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.ICreationToolEntry;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.palette.impl.StackEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextEntryHelper;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;

public class TutorialToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    public TutorialToolBehaviorProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        ICreateConnectionFeature[] features;
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_DELETE | CONTEXT_BUTTON_UPDATE);
        CustomContext cc = new CustomContext(new PictogramElement[]{pe});
        ICustomFeature[] cf = this.getFeatureProvider().getCustomFeatures((ICustomContext)cc);
        int i = 0;
        while (i < cf.length) {
            ICustomFeature iCustomFeature = cf[i];
            if (iCustomFeature instanceof TutorialCollapseDummyFeature) {
                IContextButtonEntry collapseButton = ContextEntryHelper.createCollapseContextButton((boolean)true, (IFeature)iCustomFeature, (IContext)cc);
                data.setCollapseContextButton(collapseButton);
                break;
            }
            ++i;
        }
        CreateConnectionContext ccc = new CreateConnectionContext();
        ccc.setSourcePictogramElement(pe);
        Anchor anchor = null;
        if (pe instanceof Anchor) {
            anchor = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        ccc.setSourceAnchor(anchor);
        ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
        button.setText("Create connection");
        button.setIconId("org.eclipse.graphiti.examples.tutorial.ereference");
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
            if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                button.addDragAndDropFeature((IFeature)feature);
            }
            ++n2;
        }
        if (button.getDragAndDropFeatures().size() > 0) {
            data.getDomainSpecificContextButtons().add(button);
        }
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        ContextMenuEntry subMenu = new ContextMenuEntry(null, (IContext)context);
        subMenu.setText("Cu&stom");
        subMenu.setDescription("Custom features submenu");
        subMenu.setSubmenu(true);
        ICustomFeature[] customFeatures = this.getFeatureProvider().getCustomFeatures(context);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            if (customFeature.isAvailable((IContext)context)) {
                ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                subMenu.add((IContextMenuEntry)menuEntry);
            }
            ++i;
        }
        IContextMenuEntry[] ret = new IContextMenuEntry[]{subMenu};
        return ret;
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ICreateConnectionFeature[] createConnectionFeatures;
        ICreateFeature[] createFeatures;
        ArrayList<Object> ret = new ArrayList<Object>();
        IPaletteCompartmentEntry[] superCompartments = super.getPalette();
        int i = 0;
        while (i < superCompartments.length) {
            ret.add(superCompartments[i]);
            ++i;
        }
        PaletteCompartmentEntry compartmentEntry = new PaletteCompartmentEntry("Stacked", null);
        ret.add(compartmentEntry);
        StackEntry stackEntry = new StackEntry("EObject", "EObject", null);
        compartmentEntry.addToolEntry((IToolEntry)stackEntry);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        ICreateFeature[] iCreateFeatureArray = createFeatures = featureProvider.getCreateFeatures();
        int n = createFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature cf = iCreateFeatureArray[n2];
            ObjectCreationToolEntry objectCreationToolEntry = new ObjectCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf);
            stackEntry.addCreationToolEntry((ICreationToolEntry)objectCreationToolEntry);
            ++n2;
        }
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = createConnectionFeatures = featureProvider.getCreateConnectionFeatures();
        int n3 = createConnectionFeatures.length;
        n = 0;
        while (n < n3) {
            ICreateConnectionFeature cf = iCreateConnectionFeatureArray[n];
            ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId());
            connectionCreationToolEntry.addCreateConnectionFeature(cf);
            stackEntry.addCreationToolEntry((ICreationToolEntry)connectionCreationToolEntry);
            ++n;
        }
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        TutorialRenameEClassFeature customFeature = new TutorialRenameEClassFeature(this.getFeatureProvider());
        if (customFeature.canExecute((ICustomContext)context)) {
            return customFeature;
        }
        return super.getDoubleClickFeature(context);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        EClass eClass;
        String name;
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof EClass && (name = (eClass = (EClass)bo).getName()) != null && name.length() > 0 && (name.charAt(0) < 'A' || name.charAt(0) > 'Z')) {
            ImageDecorator imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.warning.tsk");
            imageRenderingDecorator.setMessage("Name should start with upper case letter");
            return new IDecorator[]{imageRenderingDecorator};
        }
        return super.getDecorators(pe);
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof EClass) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }
        return super.getClickArea(pe);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        EList graphicsAlgorithmChildren;
        GraphicsAlgorithm invisible;
        if (pe instanceof ContainerShape && !(invisible = pe.getGraphicsAlgorithm()).getLineVisible().booleanValue() && !(graphicsAlgorithmChildren = invisible.getGraphicsAlgorithmChildren()).isEmpty()) {
            return (GraphicsAlgorithm)graphicsAlgorithmChildren.get(0);
        }
        return super.getSelectionBorder(pe);
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof EClass && (name = ((EClass)bo).getName()) != null && !name.isEmpty()) {
            return name;
        }
        return super.getToolTip(ga);
    }
}

